<?php

// مبرمج الملف ستالين - النسخة الثورية مع نظام متعدد القنوات
define("BOT_TOKEN", "1004453073:AAEoO10a4lTCk2iWDfO0wemEHcpVXeKkhho");
define("API_URL", "https://api.telegram.org/bot".BOT_TOKEN."/");
define("USERS_FILE", "users.json");
define("ROULETTES_FILE", "roulettes.json");
define("USER_CHANNELS_FILE", "user_channels.json"); // ملف جديد لقنوات المستخدمين
define("BANNED_USERS_FILE", "banned_users.json");
define("ADMINS_FILE", "admins.json"); // ملف الأدمن
define("MANDATORY_CHANNELS_FILE", "mandatory_channels.json"); // ملف القنوات الإجبارية
define("BOT_SETTINGS_FILE", "bot_settings.json"); // ملف إعدادات البوت

// معرف مالك البوت - التحكم الخاص
define("BOT_OWNER_ID", 40194242);

// الحصول على اسم البوت وتخزينه
function getBotUsername() {
    static $botUsername = null;
    
    if ($botUsername === null) {
        $botInfo = apiRequest("getMe");
        if ($botInfo && $botInfo["ok"] && isset($botInfo["result"]["username"])) {
            $botUsername = $botInfo["result"]["username"];
        } else {
            // استخدام معرف البوت كبديل
            $botUsername = explode(":", BOT_TOKEN)[0];
        }
    }
    
    return $botUsername;
}

// إنشاء الملفات إذا لم تكن موجودة
if (!file_exists(USERS_FILE)) file_put_contents(USERS_FILE, "{}");
if (!file_exists(ROULETTES_FILE)) file_put_contents(ROULETTES_FILE, "{}");
if (!file_exists(USER_CHANNELS_FILE)) file_put_contents(USER_CHANNELS_FILE, "{}");
if (!file_exists(BANNED_USERS_FILE)) file_put_contents(BANNED_USERS_FILE, "{}");
if (!file_exists(ADMINS_FILE)) file_put_contents(ADMINS_FILE, "[]");
if (!file_exists(MANDATORY_CHANNELS_FILE)) file_put_contents(MANDATORY_CHANNELS_FILE, "{}");
if (!file_exists(BOT_SETTINGS_FILE)) {
    file_put_contents(BOT_SETTINGS_FILE, json_encode([
        "notifications_enabled" => false,
        "public_channels" => [],
        "private_channels" => []
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$texts = [
    "start" => "👋 أهلاً بك في بوت الروليت!\nاضغط الزر أدناه لإنشاء روليت:",
    "channel_binding" => "1️⃣ أضف البوت كمشرف في قناتك.\n2️⃣ قم بإعادة توجيه أي رسالة من قناتك إلى البوت \n\n📌 ملاحظة:\nجميع المشرفين الآخرين في القناة سيتمكنون أيضًا من استخدام البوت بعد إضافته.",
    "roulette_text_prompt" => "أرســل كـلـيـشـة الــســحـب",
    "conditional_channel_question" => "هل تريد إضافة قناة شرط؟\n\nعند إضافة قناة شرط لن يتمكن أحد من المشاركة في السحب قبل الانضمام لقناة الشرط.\n\n+ ضروري رفع البوت ادمن في قناة الشرط والاساسيه",
    "conditional_group_question" => "هل تريد إضافة كروب شرط؟\n\nعند إضافة كروب شرط لن يتمكن أحد من المشاركة في السحب قبل الانضمام لكروب الشرط.",
    "send_conditional_link" => "أرسل رابط القناة الشرطية (مثال: @A_U_D / https://t.me/A_U_D)",
    "send_conditional_channel_2_link" => "أرسل رابط القناة الشرطية الثانية (مثال: @A_U_D / https://t.me/A_U_D)",
    "send_conditional_channel_3_link" => "أرسل رابط القناة الشرطية الثالثة (مثال: @A_U_D / https://t.me/A_U_D)",
    "send_conditional_channel_4_link" => "أرسل رابط القناة الشرطية الرابعة (مثال: @A_U_D / https://t.me/A_U_D)",
    "send_conditional_channel_5_link" => "أرسل رابط القناة الشرطية الخامسة (مثال: @A_U_D / https://t.me/A_U_D)",
    "send_conditional_group_link" => "أرسل معرف الكروب (Group ID) أو رابط الكروب الخاص:\n\n💡 أمثلة:\n• المعرف: -1001234567890\n• الرابط: https://t.me/joinchat/ABC123...\n• أو أعد توجيه رسالة من الكروب",
    "must_add_first_conditional" => "❗ يجب إضافة القناة الشرطية الأولى أولاً قبل إضافة القناة الشرطية الثانية.",
    "must_add_previous_conditional" => "❗ يجب إضافة القناة الشرطية السابقة أولاً.",
    "max_conditional_channels_reached" => "❗ تم الوصول إلى الحد الأقصى (5 قنوات شرطية).",
    "not_your_command" => "❗ هذا الأمر مخصص لمنشئ الروليت فقط.",
    "bot_owner_access" => "👑 أنت مالك البوت - لديك صلاحيات كاملة على جميع الروليتات.",
    "channel_added" => "✅ تم إضافة القناة/المجموعة: @%s\n\n📋 يمكنك الآن استخدام هذه القناة/المجموعة لإنشاء سحوبات.",
    "roulette_created" => "✅ تم نشر الروليت في القناة/المجموعة: @%s\n\nتحكم بالروليت الخاص بك من خلال رسالة السحب في القناة/المجموعة (ID: %s).",
    "roulette_published" => "🎉 تم إنشاء الروليت بنجاح ونشره!",
    "invalid_command" => "❗ أمر غير مفهوم. الرجاء استخدام الأزرار أو /start للبدء.",
    "channel_not_found" => "❗ لم أتمكن من العثور على هذه القناة/المجموعة. تأكد من صحة الرابط وأن البوت مشرف/عضو فيها.",
    "invalid_link" => "❗ الرابط غير صالح. الرجاء إرسال رابط قناة أو مجموعة صحيح (مثال: @A_U_D أو https://t.me/A_U_D).",
    "not_channel" => "❗ هذا ليس رابط قناة أو مجموعة. الرجاء إرسال رابط قناة أو مجموعة.",
    "invalid_winners" => "❗ الرجاء إرسال عدد صحيح موجب للفائزين.",
    "missing_data" => "❗ حدث خطأ: بيانات الروليت غير مكتملة. يرجى البدء من جديد عبر /start.",
    "channel_not_admin" => "❗ البوت ليس مشرفاً في هذه القناة. الرجاء إضافة البوت كمشرف وإعادة التوجيه.",
    "channel_error" => "❗ حدث خطأ أثناء التحقق من صلاحيات البوت في القناة/المجموعة. تأكد من أن القناة/المجموعة عامة وأن البوت مشرف/عضو.",
    "forward_message" => "❗ يرجى إعادة توجيه رسالة من قناة أو مجموعة أضفت فيها البوت كمشرف/عضو.",
    "text_saved" => "✅ تم حفظ الكليشة، اختر أحد الخيارات:",
    "text_updated" => "✅ تم تحديث الكليشة، اختر أحد الخيارات:",
    "channel_saved" => "✅ تم حفظ القناة الشرطية: @%s",
    "condition_added" => "✅ تم إضافة شرط %s",
    "add_second_condition_question" => "هل تريد تضيف شرط ثاني؟\n\nاختر نوع الشرط الذي تريد إضافته:",
    "enter_winners" => "📝 كم عدد الفائزين الذين تريد اختيارهم؟",
    "channel_removed" => "🗑️ تم حذف القناة/المجموعة: @%s",
    "no_channels" => "❗ لم تقم بإضافة أي قنوات أو مجموعات بعد.\n\n🔧 استخدم زر 'إدارة القنوات' لإضافة قنواتك/مجموعاتك أولاً.",
    "not_bound" => "❗ لم يتم تعيين قناة لك مسبقاً.",
    "no_text" => "❗ الرجاء إدخال كليشة السحب أولاً.",
    "joined" => "✅ تم تسجيل مشاركتك!",
    "already_joined" => "✅ أنت مشارك بالفعل في هذا السحب.\n\n⚠️ لا يمكنك المشاركة مرة أخرى.",
    "stopped" => "⛔ المشاركة في هذا السحب متوقفة حالياً.",
    "creator_join" => "لا يمكنك المشاركة في سحبك الخاص.",
    "banned" => "🚫 تم استبعادك من سحوبات هذا المنشئ.",
    "subscribe_first" => "📛 عليك الاشتراك في القناة الشرطية أولاً للمشاركة.",
    "subscribe_error" => "⚠️ خطأ في التحقق من الاشتراك في القناة الشرطية.",
    "new_participant" => "🎉 مشاركة جديدة في سحبك:\n\n👤 %s\n🆔 %d\n📊 عدد المشاركين الكلي: %d",
    "participation_on" => "✅ تم تشغيل المشاركة.",
    "participation_off" => "⛔ تم إيقاف المشاركة.",
    "no_participants" => "❗ لا يوجد مشاركون في السحب.",
    "already_drawn" => "❗ تم السحب مسبقاً لهذا الروليت.",
    "draw_complete" => "✅ تم سحب الفائزين بنجاح!",
    "winner_notification" => "🎉 تهانينا! لقد فزت في السحب:\n\n%s\n\n🏆 يمكنك التحقق من الفائزين في القناة: @%s",
    "participant_excluded" => "✅ تم استبعاد المستخدم من هذا السحب وسحوباتك المستقبلية.",
    "not_in_roulette" => "❗ هذا المشارك ليس في السحب أو تم استبعاده مسبقاً.",
    "reminder_set" => "🔔 سيتم إشعارك إذا فزت في هذا السحب!",
    "reminder_info" => "للتذكير، يجب عليك تفعيل زر التذكير لكل سحب على حدة في رسالة السحب. هذا الزر يعرض معلومات فقط.",
    "no_participants_list" => "لا يوجد مشاركون حالياً في هذا السحب.",
    "participants_list" => "قائمة المشاركين:\n%s",
    "api_error" => "❗ حدث خطأ في الاتصال بخدمة تيليجرام. يرجى المحاولة مرة أخرى.",
    "file_error" => "❗ حدث خطأ في قراءة أو كتابة البيانات. يرجى المحاولة مرة أخرى.",
    "add_to_channel" => "📥 أضفني إلى قناتك",
    "temp_file_corrupted" => "❗ حدث خطأ في البيانات المؤقتة. يرجى البدء من جديد عبر /start.",
    "notification_failed" => "⚠️ تعذر إرسال الإشعار لبعض المستخدمين (لم يبدؤوا البوت).",
    "my_channels" => "📋 قنواتي",
    "manage_channels" => "🔧 إدارة القنوات",
    "add_channel" => "➕ إضافة قناة",
    "delete_channel" => "🗑️ حذف قناة",
    "back_to_channels" => "🔙 رجوع للقنوات",
    "select_channel" => "📢 اختر القناة/المجموعة التي تريد نشر السحب فيها:",
    "no_channel_selected" => "❗ لم تختر قناة/مجموعة لنشر السحب.",
    "channel_already_exists" => "⚠️ هذه القناة/المجموعة مضافَة مسبقاً.",
    "enter_channel_username" => "📝 أرسل يوزر القناة/المجموعة (مثال: @A_U_D)\n\nأو\n\nرابط القناة/المجموعة (مثال: https://t.me/A_U_D)",
    "bot_channel_link" => "https://t.me/A_U_D",
    "admin_panel" => "⚙️ لوحة تحكم الأدمن",
    "admin_only" => "❗ هذا الأمر متاح للأدمن فقط.",
    "owner_only" => "❗ هذا الأمر متاح للمالك فقط.",
    "not_admin" => "❗ أنت لست أدمن في هذا البوت.",
    "admin_added" => "✅ تم إضافة الأدمن بنجاح.",
    "admin_removed" => "✅ تم حذف الأدمن بنجاح.",
    "user_not_found" => "❗ المستخدم غير موجود. أرسل معرف المستخدم (User ID).",
    "must_subscribe" => "📛 يجب الاشتراك في القنوات التالية للمتابعة:\n\n%s",
    "subscribe_check_failed" => "⚠️ خطأ في التحقق من الاشتراك. يرجى المحاولة مرة أخرى.",
    "notifications_enabled" => "✅ تم تفعيل الإشعارات.",
    "notifications_disabled" => "⛔ تم إيقاف الإشعارات.",
    "all_users_kicked" => "✅ تم طرد جميع المستخدمين.",
    "bot_left_all" => "✅ تم طرد البوت من جميع القنوات والمجموعات.",
    "send_to_all_users" => "👥 إرسال رسالة لجميع المستخدمين",
    "send_to_all_chats" => "📢 إرسال رسالة لجميع القنوات والمجموعات",
    "enter_message_to_send" => "📝 أرسل الرسالة التي تريد إرسالها:\n\n💡 يمكنك إرسال:\n- نص فقط\n- صورة مع نص (caption)\n- صورة فقط",
    "enter_photo_or_message" => "📷 أرسل الصورة (اختياري) ثم الرسالة النصية:\n\n💡 يمكنك إرسال:\n1. نص فقط\n2. صورة فقط\n3. صورة مع نص (caption)",
    "message_sent_to_users" => "✅ تم إرسال الرسالة بنجاح!\n\n📊 تم الإرسال إلى %d مستخدم\n⚠️ فشل الإرسال إلى %d مستخدم",
    "message_sent_to_chats" => "✅ تم إرسال الرسالة بنجاح!\n\n📊 تم الإرسال إلى %d قناة/مجموعة\n⚠️ فشل الإرسال إلى %d قناة/مجموعة",
    "new_user_notification" => "🆕 مستخدم جديد انضم للبوت!\n\n👤 الاسم: %s\n🆔 المعرف: %d\n📊 إجمالي الأعضاء: %d",
    "channel_added_mandatory" => "✅ تم إضافة القناة الإجبارية: @%s",
    "channel_removed_mandatory" => "✅ تم حذف القناة الإجبارية: @%s",
    "channel_already_mandatory" => "⚠️ هذه القناة مضافَة مسبقاً كقناة إجبارية.",
    "select_roulette_type" => "📋 اختر نوع الروليت الذي تريد إنشاءه:",
    "roulette_type_normal" => "🎯 روليت عادي\n\nنفس مميزات البوت الحالية",
    "roulette_type_anti_spam" => "🛡️ روليت ضد الرشق\n\nنفس مميزات البوت + تحقق بالإيموجي + مراقبة الخروج",
    "verification_request" => "👤 لتأكد إنك مو روبوت:\nاضغط على الزر اللي يشبه هذا الإيموجي %s",
    "verification_success" => "✅ تم تأكيد مشاركتك بنجاح!",
    "verification_failed" => "❌ الإجابة خاطئة! اضغط على زر المشاركة مرة أخرى للمحاولة.",
    "awaiting_verification" => "الانتظار...",
    "anti_spam_features" => "🛡️ الروليت ضد الرشق مفعل",
    "verification_click_to_verify" => "🔐 التحقق من المشاركة"
];

// الدوال المساعدة (نفس الدوال السابقة مع تعديلات طفيفة)
function apiRequest($method, $params = []) {
    $url = API_URL . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        error_log("cURL Error: " . $error);
        return false;
    }
    
    if ($httpCode !== 200) {
        error_log("HTTP Error: " . $httpCode . " Response: " . $response);
        return false;
    }
    
    $decoded = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("JSON Decode Error: " . json_last_error_msg() . " Response: " . $response);
        return false;
    }
    
    return $decoded;
}

function safeApiRequest($method, $params = []) {
    $response = apiRequest($method, $params);
    
    if (!$response && isset($params["chat_id"])) {
        return false;
    }
    
    return $response;
}

function readJsonFile($filename) {
    if (!file_exists($filename)) {
        return [];
    }
    
    $handle = fopen($filename, "r");
    if (!$handle) {
        error_log("Cannot open file for reading: " . $filename);
        return [];
    }
    
    if (flock($handle, LOCK_SH)) {
        $size = filesize($filename);
        
        if ($size === 0 || $size === false) {
            flock($handle, LOCK_UN);
            fclose($handle);
            return [];
        }
        
        $content = fread($handle, $size);
        flock($handle, LOCK_UN);
        fclose($handle);
        
        if ($content === false || empty(trim($content))) {
            error_log("Empty or invalid content in file: " . $filename);
            return [];
        }
        
        try {
            $data = json_decode($content, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                error_log("JSON Decode Error in file " . $filename . ": " . json_last_error_msg());
                unlink($filename);
                return [];
            }
            
            return $data;
        } catch (Exception $e) {
            error_log("Exception during JSON decode in file " . $filename . ": " . $e->getMessage());
            unlink($filename);
            return [];
        }
    } else {
        fclose($handle);
        error_log("Cannot lock file for reading: " . $filename);
        return [];
    }
}

function writeJsonFile($filename, $data) {
    if (!is_array($data) && !is_object($data)) {
        error_log("Invalid data type for JSON encoding in file: " . $filename);
        return false;
    }
    
    $json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    if ($json === false) {
        error_log("JSON Encode Error: " . json_last_error_msg());
        return false;
    }
    
    $tempFile = $filename . ".tmp." . uniqid();
    
    $handle = fopen($tempFile, "w");
    if (!$handle) {
        error_log("Cannot open temp file for writing: " . $tempFile);
        return false;
    }
    
    if (flock($handle, LOCK_EX)) {
        $bytesWritten = fwrite($handle, $json);
        fflush($handle);
        flock($handle, LOCK_UN);
        fclose($handle);
        
        if ($bytesWritten === false || $bytesWritten !== strlen($json)) {
            error_log("Failed to write complete data to temp file: " . $tempFile);
            unlink($tempFile);
            return false;
        }
        
        if (rename($tempFile, $filename)) {
            return true;
        } else {
            error_log("Failed to rename temp file to final file: " . $tempFile . " -> " . $filename);
            unlink($tempFile);
            return false;
        }
    } else {
        fclose($handle);
        unlink($tempFile);
        error_log("Cannot lock temp file for writing: " . $tempFile);
        return false;
    }
}

function buildKeyboard($buttons, $inline = true) {
    if ($inline) {
        $keyboard = ["inline_keyboard" => []];
        foreach ($buttons as $row) {
            $keyboardRow = [];
            foreach ($row as $button) {
                $buttonData = ["text" => $button["text"]];
                if (isset($button["url"])) {
                    $buttonData["url"] = $button["url"];
                } else {
                    $buttonData["callback_data"] = $button["callback"];
                }
                $keyboardRow[] = $buttonData;
            }
            $keyboard["inline_keyboard"][] = $keyboardRow;
        }
        return json_encode($keyboard);
    } else {
        $keyboard = ["keyboard" => [], "resize_keyboard" => true, "one_time_keyboard" => false];
        foreach ($buttons as $row) {
            $keyboardRow = [];
            foreach ($row as $button) {
                $keyboardRow[] = ["text" => $button["text"]];
            }
            $keyboard["keyboard"][] = $keyboardRow;
        }
        return json_encode($keyboard);
    }
}

// دوال إدارة الأدمن
function isAdmin($userId) {
    return $userId == BOT_OWNER_ID || in_array($userId, getAdmins());
}

function isOwner($userId) {
    return $userId == BOT_OWNER_ID;
}

function getAdmins() {
    $admins = readJsonFile(ADMINS_FILE);
    return is_array($admins) ? $admins : [];
}

function addAdmin($userId) {
    $admins = getAdmins();
    if (!in_array($userId, $admins)) {
        $admins[] = $userId;
        return writeJsonFile(ADMINS_FILE, $admins);
    }
    return false;
}

function removeAdmin($userId) {
    $admins = getAdmins();
    $index = array_search($userId, $admins);
    if ($index !== false) {
        unset($admins[$index]);
        return writeJsonFile(ADMINS_FILE, array_values($admins));
    }
    return false;
}

function getBotSettings() {
    return readJsonFile(BOT_SETTINGS_FILE);
}

function updateBotSettings($settings) {
    $current = getBotSettings();
    $updated = array_merge($current, $settings);
    return writeJsonFile(BOT_SETTINGS_FILE, $updated);
}

function getMandatoryChannels() {
    return readJsonFile(MANDATORY_CHANNELS_FILE);
}

function addMandatoryChannel($channelId, $channelUsername, $channelType = "public", $inviteLink = null) {
    $channels = getMandatoryChannels();
    if (!isset($channels[$channelId])) {
        $channels[$channelId] = [
            "username" => $channelUsername,
            "type" => $channelType,
            "invite_link" => $inviteLink,
            "added_at" => time()
        ];
        return writeJsonFile(MANDATORY_CHANNELS_FILE, $channels);
    }
    return false;
}

function removeMandatoryChannel($channelId) {
    $channels = getMandatoryChannels();
    if (isset($channels[$channelId])) {
        unset($channels[$channelId]);
        return writeJsonFile(MANDATORY_CHANNELS_FILE, $channels);
    }
    return false;
}

function checkMandatorySubscription($userId) {
    $channels = getMandatoryChannels();
    if (empty($channels)) {
        return ["success" => true, "missing" => []];
    }
    
    $missing = [];
    foreach ($channels as $channelId => $channelInfo) {
        // للقنوات الخاصة، نحاول التحقق إذا كان لدينا channelId حقيقي
        if ($channelInfo["type"] == "private") {
            // إذا كان channelId هو hash (32 حرف hex)، لا يمكن التحقق
            // لكن إذا كان channelId حقيقي، نحاول التحقق
            if (strlen($channelId) == 32 && ctype_xdigit($channelId)) {
                // هذا hash للقناة الخاصة برابط دعوة، لا يمكن التحقق منها
                // لكن نحاول استخدام invite link للحصول على channelId
                if (!empty($channelInfo["invite_link"])) {
                    // محاولة الحصول على معلومات القناة من رابط الدعوة
                    // للأسف، Telegram API لا يدعم getChatMember برابط الدعوة مباشرة
                    // لذا سنعتمد على أن المستخدم يشترك يدوياً
                    $missing[] = $channelInfo;
                    continue;
                }
                $missing[] = $channelInfo;
                continue;
            }
            
            // إذا كان channelId حقيقي، نحاول التحقق
            $member = apiRequest("getChatMember", [
                "chat_id" => $channelId,
                "user_id" => $userId
            ]);
            
            if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
                $missing[] = $channelInfo;
            }
            continue;
        }
        
        // للقنوات العامة، نتحقق من الاشتراك
        $member = apiRequest("getChatMember", [
            "chat_id" => $channelId,
            "user_id" => $userId
        ]);
        
        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
            $missing[] = $channelInfo;
        }
    }
    
    return [
        "success" => empty($missing),
        "missing" => $missing
    ];
}

function getUserCount() {
    $users = readJsonFile(USERS_FILE);
    $uniqueUsers = [];
    
    // إضافة جميع المستخدمين من ملف users.json
    foreach ($users as $userId => $userData) {
        if (is_numeric($userId)) {
            $uniqueUsers[$userId] = true;
        }
    }
    
    // إضافة جميع المستخدمين من الروليتات (المشاركين والمنشئين)
    $roulettes = readJsonFile(ROULETTES_FILE);
    foreach ($roulettes as $roulette) {
        // إضافة منشئ الروليت
        if (isset($roulette["creator_id"]) && is_numeric($roulette["creator_id"])) {
            $uniqueUsers[$roulette["creator_id"]] = true;
        }
        
        // إضافة جميع المشاركين
        if (isset($roulette["participants"]) && is_array($roulette["participants"])) {
            foreach ($roulette["participants"] as $participantId) {
                if (is_numeric($participantId)) {
                    $uniqueUsers[$participantId] = true;
                }
            }
        }
        
        // إضافة جميع الفائزين
        if (isset($roulette["winners"]) && is_array($roulette["winners"])) {
            foreach ($roulette["winners"] as $winnerId) {
                if (is_numeric($winnerId)) {
                    $uniqueUsers[$winnerId] = true;
                }
            }
        }
    }
    
    // إضافة جميع المستخدمين من قنوات المستخدمين
    $userChannels = readJsonFile(USER_CHANNELS_FILE);
    foreach ($userChannels as $userId => $channels) {
        if (is_numeric($userId)) {
            $uniqueUsers[$userId] = true;
        }
    }
    
    return count($uniqueUsers);
}

function getRouletteCount() {
    $roulettes = readJsonFile(ROULETTES_FILE);
    return count($roulettes);
}

function kickAllUsers() {
    $users = readJsonFile(USERS_FILE);
    $admins = getAdmins();
    $kicked = 0;
    
    foreach ($users as $userId => $userData) {
        // عدم حذف المالك والأدمن
        if ($userId != BOT_OWNER_ID && !in_array($userId, $admins)) {
            // حذف بيانات المستخدم
            unset($users[$userId]);
            
            // حذف قنوات المستخدم
            $userChannels = readJsonFile(USER_CHANNELS_FILE);
            if (isset($userChannels[$userId])) {
                unset($userChannels[$userId]);
                writeJsonFile(USER_CHANNELS_FILE, $userChannels);
            }
            
            // حذف الملفات المؤقتة للمستخدم
            $tempFile = "temp_" . $userId . ".json";
            if (file_exists($tempFile)) {
                unlink($tempFile);
            }
            
            $kicked++;
        }
    }
    
    writeJsonFile(USERS_FILE, $users);
    return $kicked;
}

function leaveAllChats() {
    $userChannels = readJsonFile(USER_CHANNELS_FILE);
    $left = 0;
    $failed = 0;
    $processedChannels = []; // لتجنب الخروج من نفس القناة مرتين
    
    // جمع جميع القنوات الفريدة من جميع المستخدمين
    foreach ($userChannels as $userId => $channels) {
        foreach ($channels as $channelId => $channelInfo) {
            if (!in_array($channelId, $processedChannels)) {
                $processedChannels[] = $channelId;
                
                // محاولة الخروج من القناة/المجموعة
                $response = apiRequest("leaveChat", ["chat_id" => $channelId]);
                
                if ($response && isset($response["ok"]) && $response["ok"]) {
                    $left++;
                } else {
                    $failed++;
                }
                
                // إضافة تأخير بسيط لتجنب rate limiting
                usleep(100000); // 0.1 ثانية
            }
        }
    }
    
    // تنظيف جميع الملفات
    writeJsonFile(USER_CHANNELS_FILE, []);
    
    // محاولة الخروج من القنوات الإجبارية أيضاً
    $mandatoryChannels = getMandatoryChannels();
    foreach ($mandatoryChannels as $channelId => $channelInfo) {
        if (!in_array($channelId, $processedChannels)) {
            $response = apiRequest("leaveChat", ["chat_id" => $channelId]);
            if ($response && isset($response["ok"]) && $response["ok"]) {
                $left++;
            }
            usleep(100000);
        }
    }
    
    return ["left" => $left, "failed" => $failed];
}

function sendNewUserNotification($userId, $userInfo) {
    $settings = getBotSettings();
    if (!$settings["notifications_enabled"]) {
        return;
    }
    
    $userCount = getUserCount();
    $displayName = getUserDisplayName($userInfo);
    
    $message = sprintf(
        $GLOBALS["texts"]["new_user_notification"],
        $displayName,
        $userId,
        $userCount
    );
    
    apiRequest("sendMessage", [
        "chat_id" => BOT_OWNER_ID,
        "text" => $message
    ]);
}

// لوحة مفاتيح لوحة التحكم
function adminPanelKeyboard() {
    return [
        [["text" => "📊 الإحصائيات", "callback" => "admin_stats"]],
        [["text" => "➕ إضافة أدمن", "callback" => "admin_add"], ["text" => "➖ حذف أدمن", "callback" => "admin_remove"]],
        [["text" => "🔔 تشغيل الإشعارات", "callback" => "admin_notify_on"], ["text" => "🔕 إيقاف الإشعارات", "callback" => "admin_notify_off"]],
        [["text" => "📛 إدارة القنوات الإجبارية", "callback" => "admin_mandatory_channels"]],
        [["text" => "👥 إرسال لجميع المستخدمين", "callback" => "admin_send_to_all_users"]],
        [["text" => "📢 إرسال لجميع القنوات", "callback" => "admin_send_to_all_chats"]],
        [["text" => "🔙 رجوع", "callback" => "back_to_main_menu"]]
    ];
}

// القائمة الرئيسية المعدلة
function mainMenuKeyboard($userId = null) {
    $keyboard = [
        [["text" => "🎯 إنشاء روليت", "callback" => "create_roulette"]],
        [["text" => "📋 قنواتي", "callback" => "my_channels"], ["text" => "🔧 إدارة القنوات", "callback" => "manage_channels"]],
        [["text" => "🔔 ذكرني إذا فزت", "callback" => "remind_me_global_info"]]
    ];
    
    // إضافة زر لوحة التحكم للأدمن فقط
    if ($userId && isAdmin($userId)) {
        $keyboard[] = [["text" => "⚙️ لوحة التحكم", "callback" => "admin_panel"]];
    }
    
    return $keyboard;
}

// لوحة مفاتيح إدارة القنوات
function channelsManagementKeyboard() {
    return [
        [["text" => "➕ إضافة قناة", "callback" => "add_channel"], ["text" => "➕ إضافة كروب", "callback" => "add_group"]],
        [["text" => "🔒 إضافة قناة خاصة", "callback" => "add_private_channel"]],
        [["text" => "🗑️ حذف قناة", "callback" => "delete_channel"]],
        [["text" => "📋 قنواتي", "callback" => "my_channels"]],
        [["text" => "🔙 رجوع", "callback" => "back_to_main_menu"]]
    ];
}

// لوحة مفاتيح القنوات
function myChannelsKeyboard($userId) {
    $userChannels = readJsonFile(USER_CHANNELS_FILE);
    $keyboard = [];
    
    if (isset($userChannels[$userId]) && !empty($userChannels[$userId])) {
        foreach ($userChannels[$userId] as $channelId => $channelInfo) {
            $keyboard[] = [[
                "text" => "📢 " . $channelInfo["username"],
                "callback" => "select_channel_" . $channelId
            ]];
        }
    }
    
    $keyboard[] = [["text" => "➕ إضافة قناة", "callback" => "add_channel"], ["text" => "➕ إضافة كروب", "callback" => "add_group"]];
    $keyboard[] = [["text" => "🔙 رجوع", "callback" => "back_to_main_menu"]];
    
    return $keyboard;
}

// لوحة مفاتيح حذف القنوات
function deleteChannelsKeyboard($userId) {
    $userChannels = readJsonFile(USER_CHANNELS_FILE);
    $keyboard = [];
    
    if (isset($userChannels[$userId]) && !empty($userChannels[$userId])) {
        foreach ($userChannels[$userId] as $channelId => $channelInfo) {
            $keyboard[] = [[
                "text" => "🗑️ " . $channelInfo["username"],
                "callback" => "confirm_delete_channel_" . $channelId
            ]];
        }
    }
    
    $keyboard[] = [["text" => "🔙 رجوع", "callback" => "back_to_channels_management"]];
    
    return $keyboard;
}

// باقي الدوال (نفس الدوال السابقة مع تعديلات طفيفة)
function rouletteOptionsKeyboard() {
    return [
        [["text" => "➕ إضافة قناة شرط", "callback" => "prompt_conditional_channel"], ["text" => "➕ إضافة كروب شرط", "callback" => "prompt_conditional_group"]],
        [["text" => "🚀 إضافة شرط تعزيز قناة", "callback" => "prompt_boost_channel"]],
        [["text" => "🗳️ إضافة شرط تصويت", "callback" => "prompt_vote_link"]],
        [["text" => "⭐ إضافة شرط حساب مميز", "callback" => "toggle_premium_requirement"]],
        [["text" => "🔢 إضافة شرط يوزر ثلاثي", "callback" => "toggle_tripartite_username_requirement"]],
        [["text" => "⏭️ تخطي", "callback" => "skip_conditional_channel"]]
    ];
}

function conditionalChannelKeyboard() {
    return [
        [["text" => "🔗 إضافة رابط قناة", "callback" => "send_conditional_channel_link_prompt"],
         ["text" => "⏭️ تخطي", "callback" => "skip_conditional_channel"]]
    ];
}

function conditionalChannel2Keyboard() {
    return [
        [["text" => "🔗 إضافة رابط قناة", "callback" => "prompt_conditional_channel_2"],
         ["text" => "⏭️ تخطي", "callback" => "skip_conditional_channel"]]
    ];
}

function conditionalGroupKeyboard() {
    return [
        [["text" => "🔗 إضافة رابط/معرف كروب", "callback" => "send_conditional_group_link_prompt"],
         ["text" => "⏭️ تخطي", "callback" => "skip_conditional_channel"]]
    ];
}

function addSecondConditionKeyboard($userId = null) {
    $keyboard = [];
    
    // إضافة أزرار القنوات الشرطية حسب العدد الموجود
    if ($userId) {
        $userTempData = readTempFile($userId);
        $channelsCount = 0;
        if (!empty($userTempData["conditional_channel_id"])) $channelsCount++;
        if (!empty($userTempData["conditional_channel_2_id"])) $channelsCount++;
        if (!empty($userTempData["conditional_channel_3_id"])) $channelsCount++;
        if (!empty($userTempData["conditional_channel_4_id"])) $channelsCount++;
        if (!empty($userTempData["conditional_channel_5_id"])) $channelsCount++;
        
        if ($channelsCount < 5) {
            if ($channelsCount == 0) {
                $keyboard[] = [["text" => "➕ إضافة قناة شرط", "callback" => "prompt_conditional_channel"]];
            } else if ($channelsCount == 1) {
                $keyboard[] = [["text" => "➕ إضافة قناة شرط ثانية", "callback" => "prompt_conditional_channel_2"]];
            } else if ($channelsCount == 2) {
                $keyboard[] = [["text" => "➕ إضافة قناة شرط ثالثة", "callback" => "prompt_conditional_channel_3"]];
            } else if ($channelsCount == 3) {
                $keyboard[] = [["text" => "➕ إضافة قناة شرط رابعة", "callback" => "prompt_conditional_channel_4"]];
            } else if ($channelsCount == 4) {
                $keyboard[] = [["text" => "➕ إضافة قناة شرط خامسة", "callback" => "prompt_conditional_channel_5"]];
            }
        }
    } else {
        // إذا لم يتم تمرير userId، نعرض جميع الأزرار
        $keyboard[] = [["text" => "➕ إضافة قناة شرط ثانية", "callback" => "prompt_conditional_channel_2"]];
    }
    
    $keyboard[] = [["text" => "➕ إضافة كروب شرط", "callback" => "prompt_conditional_group"]];
    $keyboard[] = [["text" => "🚀 إضافة شرط تعزيز قناة", "callback" => "prompt_boost_channel"]];
    $keyboard[] = [["text" => "🗳️ إضافة شرط تصويت", "callback" => "prompt_vote_link"]];
    $keyboard[] = [["text" => "⭐ إضافة شرط حساب مميز", "callback" => "toggle_premium_requirement"]];
    $keyboard[] = [["text" => "🔢 إضافة شرط يوزر ثلاثي", "callback" => "toggle_tripartite_username_requirement"]];
    $keyboard[] = [["text" => "⏭️ تخطي", "callback" => "skip_conditional_channel"]];
    
    return $keyboard;
}

function rouletteTypeKeyboard() {
    global $texts;
    return [
        [["text" => "🎯 روليت عادي", "callback" => "select_type_normal"]],
        [["text" => "🛡️ روليت ضد الرشق", "callback" => "select_type_anti_spam"]]
    ];
}

function verificationKeyboard($options, $verificationCode) {
    $botUsername = getBotUsername();
    $keyboard = [];
    foreach ($options as $option) {
        $emoji = $option["emoji"];
        $code = $option["code"];
        $botLink = "https://t.me/".$botUsername."?start=verify_".$verificationCode."_".$code;
        $keyboard[] = [[
            "text" => $emoji,
            "url" => $botLink
        ]];
    }
    return $keyboard;
}

function rouletteChannelKeyboard($rouletteId, $isActive, $creatorId, $rouletteType = "normal") {
    $botUsername = getBotUsername();
    
    // إذا كان anti_spam، زر المشاركة يكون رابط يفتح البوت
    if ($rouletteType == "anti_spam") {
        $keyboard = [
            [["text" => "🎁 المشاركة في السحب", "url" => "https://t.me/".$botUsername."?start=join_".$rouletteId]],
            [["text" => "🔔 ذكرني إذا فزت", "url" => "https://t.me/".$botUsername."?start=remind_".$rouletteId]]
        ];
    } else {
        $keyboard = [
            [["text" => "🎁 المشاركة في السحب", "callback" => "join_roulette_".$rouletteId]],
            [["text" => "🔔 ذكرني إذا فزت", "url" => "https://t.me/".$botUsername."?start=remind_".$rouletteId]]
        ];
    }
    
    $keyboard[] = [
        ["text" => ($isActive ? "⏸️ إيقاف المشاركة" : "▶️ تشغيل المشاركة"), "callback" => "toggle_participation_".$rouletteId],
        ["text" => "🏁 ابدأ السحب", "callback" => "start_draw_".$rouletteId]
    ];
    $keyboard[] = [["text" => "📊 عرض المشاركين", "callback" => "view_participants_".$rouletteId]];
    
    return $keyboard;
}

function excludeParticipantKeyboard($rouletteId, $participantId) {
    return [
        [["text" => "❌ استبعاد هذا المشارك", "callback" => "exclude_participant_".$rouletteId."_".$participantId]]
    ];
}

function readData($file) {
    return readJsonFile($file);
}

function saveData($file, $data) {
    return writeJsonFile($file, $data);
}

function readTempFile($userId) {
    global $texts;
    
    $tempFile = "temp_".$userId.".json";
    $data = readJsonFile($tempFile);
    
    if (empty($data)) {
        if (file_exists($tempFile)) {
            unlink($tempFile);
        }
        return false;
    }
    
    return $data;
}

function writeTempFile($userId, $data) {
    $tempFile = "temp_".$userId.".json";
    return writeJsonFile($tempFile, $data);
}

function cleanupTempFiles() {
    $pattern = "temp_*.json";
    $files = glob($pattern);
    
    foreach ($files as $file) {
        if (file_exists($file) && (time() - filemtime($file)) > 3600) {
            unlink($file);
            error_log("Cleaned up old temp file: " . $file);
        }
    }
}

function getUserDisplayName($userInfo) {
    if (isset($userInfo["username"]) && !empty($userInfo["username"])) {
        return "@" . $userInfo["username"];
    } elseif (isset($userInfo["first_name"]) && !empty($userInfo["first_name"])) {
        $name = $userInfo["first_name"];
        if (isset($userInfo["last_name"]) && !empty($userInfo["last_name"])) {
            $name .= " " . $userInfo["last_name"];
        }
        return $name;
    } else {
        return "المستخدم " . $userInfo["id"];
    }
}

function updateRouletteMessage($rouletteId) {
    global $texts;
    
    $roulettes = readData(ROULETTES_FILE);
    if (!isset($roulettes[$rouletteId])) {
        error_log("Roulette not found: " . $rouletteId);
        return false;
    }
    
    $r = $roulettes[$rouletteId];
    $participantsCount = count($r["participants"]);
    $updatedText = $r["text"] . "\n\n👥 عدد المشاركين: " . $participantsCount;
    
    // جمع جميع الشروط لعرضها
    $conditions = [];
    $conditionNum = 1;
    
    if (!empty($r['conditional_channel_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $r['conditional_channel_username'];
    }
    if (!empty($r['conditional_channel_2_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $r['conditional_channel_2_username'];
    }
    if (!empty($r['conditional_channel_3_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $r['conditional_channel_3_username'];
    }
    if (!empty($r['conditional_channel_4_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $r['conditional_channel_4_username'];
    }
    if (!empty($r['conditional_channel_5_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $r['conditional_channel_5_username'];
    }
    if (!empty($r['conditional_group_id'])) {
        $groupTitle = !empty($r['conditional_group_title']) ? $r['conditional_group_title'] : 'الكروب';
        $groupLink = !empty($r['conditional_group_link']) ? $r['conditional_group_link'] : 'https://t.me/';
        $conditions[] = $conditionNum++ . "- الانضمام هنا >> <a href=\"" . htmlspecialchars($groupLink) . "\">" . htmlspecialchars($groupTitle) . "</a>";
    }
    if (!empty($r['boost_channel_username'])) {
        $boostLink = !empty($r['boost_channel_link']) ? $r['boost_channel_link'] : 'https://t.me/boost/' . ltrim($r['boost_channel_username'], '@');
        $conditions[] = $conditionNum++ . "- تعزيز القناة >> <a href=\"" . htmlspecialchars($boostLink) . "\">" . htmlspecialchars($r['boost_channel_username']) . "</a>";
    }
    if (!empty($r['vote_link'])) {
        $conditions[] = $conditionNum++ . "- التصويت هنا >> <a href=\"" . htmlspecialchars($r['vote_link']) . "\">رابط التصويت</a>";
    }
    if (!empty($r['require_premium'])) {
        $conditions[] = $conditionNum++ . "- الحساب يجب أن يكون مفعل بريميوم ⭐";
    }
    if (!empty($r['require_nft_username'])) {
        $conditions[] = $conditionNum++ . "- يجب أن تمتلك يوزر منصة NFT 🎨";
    }
    if (!empty($r['require_tripartite_username'])) {
        $conditions[] = $conditionNum++ . "- يجب أن يكون يوزرك بصيغة ثلاثية (مثال: @A_U_D) 🔢";
    }
    if (!empty($r['variable_username_pattern'])) {
        $conditions[] = $conditionNum++ . "- يجب أن يكون يوزرك يطابق النمط: " . htmlspecialchars($r['variable_username_pattern']) . " 📝";
    }
    
    if (!empty($conditions)) {
        $updatedText .= "\n\nللمشاركة تحتاج إلى :\n    " . implode("\n    ", $conditions);
    }
    
    if (!$r["active"]) {
        $updatedText .= "\n⛔ المشاركة متوقفة حالياً.";
    }
    
    if (!empty($r["winners"])) {
        $winnersNames = [];
        foreach ($r["winners"] as $winner_id) {
            $userInfo = apiRequest("getChat", ["chat_id" => $winner_id]);
            if ($userInfo && $userInfo["ok"]) {
                $winnersNames[] = getUserDisplayName($userInfo["result"]);
            } else {
                $winnersNames[] = "المستخدم " . $winner_id;
            }
        }
        $updatedText .= "\n\n🏆 الفائزون:\n" . implode("\n", $winnersNames);
    }
    
    // إضافة رابط البوت في نهاية النص
    $botUsername = getBotUsername();
    $botLink = "tg://resolve?domain=" . $botUsername;
    $updatedText .= "\n\n<a href=\"" . $botLink . "\">روليت رادار</a>";

    $params = [
        "chat_id" => $r["main_channel_id"],
        "message_id" => $r["channel_message_id"],
        "text" => $updatedText,
        "parse_mode" => "HTML",
        "reply_markup" => buildKeyboard(rouletteChannelKeyboard($rouletteId, $r["active"], $r["creator_id"], $r["roulette_type"] ?? "normal"), true)
    ];
    $response = apiRequest("editMessageText", $params);

    if (!$response || !$response["ok"]) {
        error_log("Failed to update roulette message: " . json_encode($response));
        return false;
    }
    
    return true;
}

// دالة نشر الروليت المعدلة
function publishRoulette($userId) {
    global $texts;

    $userTempData = readTempFile($userId);
    if (!$userTempData || !isset($userTempData["roulette_text"]) || 
        !isset($userTempData["selected_channel_id"]) || !isset($userTempData["winners_count"])) {
        apiRequest("sendMessage", [
            "chat_id" => $userId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return false;
    }

    $rouletteId = uniqid();
    // لا نطبع أي فائزين ولا حتى خانة الفائزين
    $initialText = $userTempData["roulette_text"] . "\n\n👥 عدد المشاركين: 0";
    
    // جمع جميع الشروط لعرضها
    $conditions = [];
    $conditionNum = 1;
    
    if (!empty($userTempData['conditional_channel_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $userTempData['conditional_channel_username'];
    }
    if (!empty($userTempData['conditional_channel_2_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $userTempData['conditional_channel_2_username'];
    }
    if (!empty($userTempData['conditional_channel_3_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $userTempData['conditional_channel_3_username'];
    }
    if (!empty($userTempData['conditional_channel_4_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $userTempData['conditional_channel_4_username'];
    }
    if (!empty($userTempData['conditional_channel_5_username'])) {
        $conditions[] = $conditionNum++ . "- الإشتراك هنا >> @" . $userTempData['conditional_channel_5_username'];
    }
    if (!empty($userTempData['conditional_group_id'])) {
        $groupTitle = !empty($userTempData['conditional_group_title']) ? $userTempData['conditional_group_title'] : 'الكروب';
        $groupLink = !empty($userTempData['conditional_group_link']) ? $userTempData['conditional_group_link'] : 'https://t.me/';
        $conditions[] = $conditionNum++ . "- الانضمام هنا >> <a href=\"" . htmlspecialchars($groupLink) . "\">" . htmlspecialchars($groupTitle) . "</a>";
    }
    if (!empty($userTempData['boost_channel_username'])) {
        $boostLink = !empty($userTempData['boost_channel_link']) ? $userTempData['boost_channel_link'] : 'https://t.me/boost/' . ltrim($userTempData['boost_channel_username'], '@');
        $conditions[] = $conditionNum++ . "- تعزيز القناة >> <a href=\"" . htmlspecialchars($boostLink) . "\">" . htmlspecialchars($userTempData['boost_channel_username']) . "</a>";
    }
    if (!empty($userTempData['vote_link'])) {
        $conditions[] = $conditionNum++ . "- التصويت هنا >> <a href=\"" . htmlspecialchars($userTempData['vote_link']) . "\">رابط التصويت</a>";
    }
    if (!empty($userTempData['require_premium'])) {
        $conditions[] = $conditionNum++ . "- الحساب يجب أن يكون مفعل بريميوم ⭐";
    }
    if (!empty($userTempData['require_nft_username'])) {
        $conditions[] = $conditionNum++ . "- يجب أن تمتلك يوزر منصة NFT 🎨";
    }
    if (!empty($userTempData['require_tripartite_username'])) {
        $conditions[] = $conditionNum++ . "- يجب أن يكون يوزرك بصيغة ثلاثية (مثال: @A_U_D) 🔢";
    }
    if (!empty($userTempData['variable_username_pattern'])) {
        $conditions[] = $conditionNum++ . "- يجب أن يكون يوزرك يطابق النمط: " . htmlspecialchars($userTempData['variable_username_pattern']) . " 📝";
    }
    
    if (!empty($conditions)) {
        $initialText .= "\n\nللمشاركة تحتاج إلى :\n    " . implode("\n    ", $conditions);
    }
    
    // إضافة رابط البوت في نهاية النص
    $botUsername = getBotUsername();
    $botLink = "tg://resolve?domain=" . $botUsername;
    $initialText .= "\n\n<a href=\"" . $botLink . "\">روليت رادار</a>";

    $rouletteType = $userTempData["roulette_type"] ?? "normal";
    
    $params = [
        "chat_id" => $userTempData["selected_channel_id"],
        "text" => $initialText,
        "parse_mode" => "HTML",
        "reply_markup" => buildKeyboard(rouletteChannelKeyboard($rouletteId, true, $userId, $rouletteType), true)
    ];
    $response = apiRequest("sendMessage", $params);

    if (!$response || !$response["ok"]) {
        apiRequest("sendMessage", [
            "chat_id" => $userId,
            "text" => "❗ فشل في النشر داخل القناة. تأكد أن البوت مشرف ولديه صلاحية إرسال الرسائل."
        ]);
        return false;
    }

    $roulettes = readData(ROULETTES_FILE);
    $roulettes[$rouletteId] = [
        "creator_id" => $userId,
        "main_channel_id" => $userTempData["selected_channel_id"],
        "main_channel_username" => $userTempData["selected_channel_username"],
        "channel_message_id" => $response["result"]["message_id"],
        "text" => $userTempData["roulette_text"],
        "roulette_type" => $rouletteType,
        "conditional_channel_id" => $userTempData["conditional_channel_id"] ?? null,
        "conditional_channel_username" => $userTempData["conditional_channel_username"] ?? null,
        "conditional_channel_2_id" => $userTempData["conditional_channel_2_id"] ?? null,
        "conditional_channel_2_username" => $userTempData["conditional_channel_2_username"] ?? null,
        "conditional_channel_3_id" => $userTempData["conditional_channel_3_id"] ?? null,
        "conditional_channel_3_username" => $userTempData["conditional_channel_3_username"] ?? null,
        "conditional_channel_4_id" => $userTempData["conditional_channel_4_id"] ?? null,
        "conditional_channel_4_username" => $userTempData["conditional_channel_4_username"] ?? null,
        "conditional_channel_5_id" => $userTempData["conditional_channel_5_id"] ?? null,
        "conditional_channel_5_username" => $userTempData["conditional_channel_5_username"] ?? null,
        "conditional_group_id" => $userTempData["conditional_group_id"] ?? null,
        "conditional_group_username" => $userTempData["conditional_group_username"] ?? null,
        "conditional_group_title" => $userTempData["conditional_group_title"] ?? null,
        "conditional_group_link" => $userTempData["conditional_group_link"] ?? null,
        "boost_channel_id" => $userTempData["boost_channel_id"] ?? null,
        "boost_channel_username" => $userTempData["boost_channel_username"] ?? null,
        "boost_channel_link" => $userTempData["boost_channel_link"] ?? null,
        "vote_link" => $userTempData["vote_link"] ?? null,
        "require_premium" => $userTempData["require_premium"] ?? false,
        "require_nft_username" => $userTempData["require_nft_username"] ?? false,
        "require_tripartite_username" => $userTempData["require_tripartite_username"] ?? false,
        "variable_username_pattern" => $userTempData["variable_username_pattern"] ?? null,
        "winners_count" => $userTempData["winners_count"],
        "participants" => [],
        "active" => true,
        "winners" => [],
        "reminders" => []
    ];

    if (!saveData(ROULETTES_FILE, $roulettes)) {
        apiRequest("sendMessage", [
            "chat_id" => $userId,
            "text" => $texts["file_error"]
        ]);
        return false;
    }

    apiRequest("sendMessage", [
        "chat_id" => $userId,
        "text" => sprintf($texts["roulette_created"], $userTempData["selected_channel_username"], $rouletteId)
    ]);

    apiRequest("sendMessage", [
        "chat_id" => $userId,
        "text" => $texts["roulette_published"]
    ]);

    $tempFile = "temp_".$userId.".json";
    if (file_exists($tempFile)) {
        unlink($tempFile);
    }

    return true;
}

// دوال جديدة لإدارة القنوات
function addUserChannel($userId, $channelId, $channelUsername) {
    $userChannels = readData(USER_CHANNELS_FILE);
    
    if (!isset($userChannels[$userId])) {
        $userChannels[$userId] = [];
    }
    
    // التحقق من عدم تكرار القناة
    foreach ($userChannels[$userId] as $existingChannelId => $channelInfo) {
        if ($existingChannelId == $channelId) {
            return false; // القناة موجودة مسبقاً
        }
    }
    
    $userChannels[$userId][$channelId] = [
        "username" => $channelUsername,
        "added_at" => time()
    ];
    
    return saveData(USER_CHANNELS_FILE, $userChannels);
}

function removeUserChannel($userId, $channelId) {
    $userChannels = readData(USER_CHANNELS_FILE);
    
    if (isset($userChannels[$userId][$channelId])) {
        unset($userChannels[$userId][$channelId]);
        return saveData(USER_CHANNELS_FILE, $userChannels);
    }
    
    return false;
}

function getUserChannels($userId) {
    $userChannels = readData(USER_CHANNELS_FILE);
    return $userChannels[$userId] ?? [];
}

function generateVerification() {
    // توليد تحقق بالإيموجي
    $emojiSets = [
        ["emoji" => "🎁", "code" => "1", "wrong" => ["✅", "❤️‍🔥"]],
        ["emoji" => "📦", "code" => "2", "wrong" => ["🎯", "⭐"]],
        ["emoji" => "🎈", "code" => "3", "wrong" => ["🎂", "🎊"]],
        ["emoji" => "🎨", "code" => "4", "wrong" => ["🎵", "🎪"]],
        ["emoji" => "🏆", "code" => "5", "wrong" => ["🎖️", "🥇"]],
        ["emoji" => "🎮", "code" => "6", "wrong" => ["🎲", "🃏"]],
        ["emoji" => "🎭", "code" => "7", "wrong" => ["🎬", "🎤"]]
    ];
    
    $selectedSet = $emojiSets[array_rand($emojiSets)];
    $targetEmoji = $selectedSet["emoji"];
    $targetCode = $selectedSet["code"];
    $wrongEmojis = $selectedSet["wrong"];
    
    // خلط الأزرار
    $allOptions = array_merge([["emoji" => $targetEmoji, "code" => $targetCode]], [
        ["emoji" => $wrongEmojis[0], "code" => "0"],
        ["emoji" => $wrongEmojis[1], "code" => "0"]
    ]);
    shuffle($allOptions);
    
    return [
        "target" => $targetCode,
        "target_emoji" => $targetEmoji,
        "options" => $allOptions
    ];
}

// معالجة الرسائل المعدلة
function processMessage($update) {
    global $texts;
    
    $message = $update["message"];
    $userId = $message["from"]["id"];
    $chatId = $message["chat"]["id"];
    $chatType = $message["chat"]["type"] ?? "";
    $text = $message["text"] ?? "";
    
    // في المجموعات: تجاهل جميع الرسائل بما في ذلك /start و /admin
    if (in_array($chatType, ["group", "supergroup"])) {
        // تجاهل الرسائل الآلية (مثل إضافة عضو)
        if (!isset($message["from"])) {
            return;
        }
        
        // منع /start و /admin في الكروبات - يجب استخدامهما في المحادثات الخاصة فقط
        return;
    }
    
    // تنظيف الملفات المؤقتة القديمة بشكل دوري
    if (rand(1, 100) == 1) {
        cleanupTempFiles();
    }
    
    // التحقق من أمر لوحة الأدمن
    if (strpos($text, "/admin") === 0) {
        if (!isAdmin($userId)) {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["admin_only"]
            ]);
            return;
        }
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["admin_panel"],
            "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
        ]);
        return;
    }
    
    // التحقق من أمر البدء
    if (strpos($text, "/start") === 0) {
        $userStates = readData(USERS_FILE);
        unset($userStates[$userId]["state"]);
        saveData(USERS_FILE, $userStates);
        
        $tempFile = "temp_".$userId.".json";
        if (file_exists($tempFile)) {
            unlink($tempFile);
        }
        
        // التحقق من المشاركة في روليت ضد الرشق
        if (strpos($text, "/start join_") === 0) {
            $rouletteId = str_replace("/start join_", "", $text);
            
            // قراءة بيانات الروليت
            $roulettes = readData(ROULETTES_FILE);
            if (!isset($roulettes[$rouletteId])) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => "❗ هذا السحب لم يعد موجوداً."
                ]);
                return;
            }
            
            $r = $roulettes[$rouletteId];
            
            // التحقق من حالة المشاركة (active)
            if (!$r["active"]) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["stopped"]
                ]);
                return;
            }
            
            // التحقق من القنوات/الكروبات الشرطية أولاً
            if (!empty($r["conditional_channel_id"])) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $r["conditional_channel_id"],
                    "user_id" => $userId
                ]);
                if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => $texts["subscribe_first"]
                    ]);
                    return;
                }
            }
            
            if (!empty($r["conditional_channel_2_id"])) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $r["conditional_channel_2_id"],
                    "user_id" => $userId
                ]);
                if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => $texts["subscribe_first"]
                    ]);
                    return;
                }
            }
            
            if (!empty($r["conditional_channel_3_id"])) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $r["conditional_channel_3_id"],
                    "user_id" => $userId
                ]);
                if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => $texts["subscribe_first"]
                    ]);
                    return;
                }
            }
            
            if (!empty($r["conditional_channel_4_id"])) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $r["conditional_channel_4_id"],
                    "user_id" => $userId
                ]);
                if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => $texts["subscribe_first"]
                    ]);
                    return;
                }
            }
            
            if (!empty($r["conditional_channel_5_id"])) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $r["conditional_channel_5_id"],
                    "user_id" => $userId
                ]);
                if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => $texts["subscribe_first"]
                    ]);
                    return;
                }
            }
            
            if (!empty($r["conditional_group_id"])) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $r["conditional_group_id"],
                    "user_id" => $userId
                ]);
                if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => $texts["subscribe_first"]
                    ]);
                    return;
                }
            }
            
            // فحص شرط تعزيز القناة قبل إرسال سؤال التحقق
            if (!empty($r["boost_channel_id"])) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $r["boost_channel_id"],
                    "user_id" => $userId
                ]);
                if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                    $boostLink = !empty($r['boost_channel_link']) ? $r['boost_channel_link'] : 'https://t.me/boost/' . ltrim($r['boost_channel_username'] ?? '', '@');
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => "❗ يجب الاشتراك وتعزيز القناة أولاً للمشاركة.\n\n🚀 اضغط على رابط التعزيز: " . $boostLink
                    ]);
                    return;
                }
            }
            
            // التحقق من نوع الروليت
            if (isset($r["roulette_type"]) && $r["roulette_type"] == "anti_spam") {
                // التحقق من أن المستخدم لم يشارك من قبل
                if (in_array($userId, $r["participants"] ?? [])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => "✅ أنت مشارك من قبل في هذا السحب."
                    ]);
                    return;
                }
                
                // توليد سؤال التحقق
                $verification = generateVerification();
                $verificationCode = uniqid();
                
                // حفظ بيانات التحقق
                $verificationFile = "verification_".$rouletteId.".json";
                $verificationData = [
                    "code" => $verificationCode,
                    "target" => $verification["target"],
                    "roulette_id" => $rouletteId
                ];
                writeJsonFile($verificationFile, $verificationData);
                
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => sprintf($texts["verification_request"], $verification["target_emoji"]),
                    "reply_markup" => buildKeyboard(verificationKeyboard($verification["options"], $verificationCode), true)
                ]);
                return;
            }
        }
        
        // التحقق من تأكيد التحقق بالإيموجي
        if (strpos($text, "/start verify_") === 0) {
            $parts = explode("_", str_replace("/start verify_", "", $text));
            if (count($parts) >= 2) {
                $verificationCode = $parts[0];
                $selectedCode = $parts[1];
                
                // البحث عن ملف التحقق الذي يحتوي على هذا الكود
                $verificationFiles = glob("verification_*.json");
                foreach ($verificationFiles as $file) {
                    $verificationData = readJsonFile($file);
                    if (isset($verificationData["code"]) && $verificationData["code"] === $verificationCode) {
                        $rouletteId = $verificationData["roulette_id"];
                        $targetCode = $verificationData["target"] ?? null;
                        
                        if ($targetCode !== null) {
                            // التحقق من الإجابة
                            if ($selectedCode == $targetCode) {
                                // التحقق صحيح - إضافة المستخدم
                                $roulettes = readData(ROULETTES_FILE);
                                
                                if (isset($roulettes[$rouletteId])) {
                                    $r = $roulettes[$rouletteId];
                                    
                                    // التحقق من حالة المشاركة (active)
                                    if (!$r["active"]) {
                                        apiRequest("sendMessage", [
                                            "chat_id" => $chatId,
                                            "text" => $texts["stopped"]
                                        ]);
                                        return;
                                    }
                                    
                                    // التحقق من القنوات/الكروبات الشرطية مرة أخرى
                                    if (!empty($r["conditional_channel_id"])) {
                                        $member = apiRequest("getChatMember", [
                                            "chat_id" => $r["conditional_channel_id"],
                                            "user_id" => $userId
                                        ]);
                                        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => $texts["subscribe_first"]
                                            ]);
                                            return;
                                        }
                                    }
                                    
                                    if (!empty($r["conditional_group_id"])) {
                                        $member = apiRequest("getChatMember", [
                                            "chat_id" => $r["conditional_group_id"],
                                            "user_id" => $userId
                                        ]);
                                        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => $texts["subscribe_first"]
                                            ]);
                                            return;
                                        }
                                    }
                                    
                                    // فحص شرط تعزيز القناة
                                    if (!empty($r["boost_channel_id"])) {
                                        $member = apiRequest("getChatMember", [
                                            "chat_id" => $r["boost_channel_id"],
                                            "user_id" => $userId
                                        ]);
                                        if (!$member || !$member["ok"] || in_array($member["result"]["status"] ?? "", ["left", "kicked"])) {
                                            $boostLink = !empty($r['boost_channel_link']) ? $r['boost_channel_link'] : 'https://t.me/boost/' . ltrim($r['boost_channel_username'] ?? '', '@');
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ يجب الاشتراك وتعزيز القناة أولاً للمشاركة.\n\n🚀 اضغط على رابط التعزيز: " . $boostLink
                                            ]);
                                            return;
                                        }
                                    }
                                    
                                    // فحص شرط الحساب المميز
                                    if (!empty($r["require_premium"])) {
                                        $isPremium = false;
                                        
                                        // دالة مساعدة للتحقق من Premium من أي مصدر - أكثر مرونة
                                        $checkPremium = function($userData) {
                                            if (!is_array($userData) || !array_key_exists("is_premium", $userData)) {
                                                return false;
                                            }
                                            $value = $userData["is_premium"];
                                            // التحقق من جميع الأشكال الممكنة: true, 1, "true", "1", أو أي قيمة truthy
                                            if ($value === true || $value === 1 || $value === "true" || $value === "1") {
                                                return true;
                                            }
                                            // التحقق من القيم truthy الأخرى (لكن بحذر)
                                            if ($value && $value !== false && $value !== 0 && $value !== "false" && $value !== "0") {
                                                return true;
                                            }
                                            return false;
                                        };
                                        
                                        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
                                        if ($userInfo && $userInfo["ok"] && isset($userInfo["result"]) && is_array($userInfo["result"])) {
                                            if ($checkPremium($userInfo["result"])) {
                                                $isPremium = true;
                                            }
                                        }
                                        
                                        // محاولة أخرى باستخدام getChatMember من أي قناة متاحة
                                        if (!$isPremium) {
                                            $channelsToCheck = [];
                                            if (!empty($r["main_channel_id"])) $channelsToCheck[] = $r["main_channel_id"];
                                            if (!empty($r["conditional_channel_id"])) $channelsToCheck[] = $r["conditional_channel_id"];
                                            if (!empty($r["conditional_channel_2_id"])) $channelsToCheck[] = $r["conditional_channel_2_id"];
                                            if (!empty($r["boost_channel_id"])) $channelsToCheck[] = $r["boost_channel_id"];
                                            
                                            foreach ($channelsToCheck as $channelId) {
                                                $member = apiRequest("getChatMember", [
                                                    "chat_id" => $channelId,
                                                    "user_id" => $userId
                                                ]);
                                                if ($member && $member["ok"] && isset($member["result"]["user"]) && is_array($member["result"]["user"]) && $checkPremium($member["result"]["user"])) {
                                                    $isPremium = true;
                                                    break;
                                                }
                                            }
                                        }
                                        
                                        if (!$isPremium) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ يجب أن يكون حسابك مفعل بريميوم (Premium) للمشاركة."
                                            ]);
                                            return;
                                        }
                                    }
                                    
                                    // فحص شرط يوزر NFT
                                    if (!empty($r["require_nft_username"])) {
                                        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
                                        if (!$userInfo || !$userInfo["ok"] || empty($userInfo["result"]["username"] ?? "")) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ يجب أن تمتلك يوزر منصة NFT للمشاركة."
                                            ]);
                                            return;
                                        }
                                    }
                                    
                                    // فحص شرط اليوزر الثلاثي
                                    if (!empty($r["require_tripartite_username"])) {
                                        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
                                        if (!$userInfo || !$userInfo["ok"]) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ خطأ في التحقق من بياناتك."
                                            ]);
                                            return;
                                        }
                                        $username = $userInfo["result"]["username"] ?? "";
                                        // التحقق من صيغة اليوزر الثلاثي - يجب أن يكون 3 أحرف فقط (مثال: A_U_D)
                                        if (empty($username) || !preg_match("/^[a-zA-Z0-9]_[a-zA-Z0-9]_[a-zA-Z0-9]$/", $username)) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ يجب أن يكون يوزرك بصيغة ثلاثية بالضبط (مثال: @A_U_D)."
                                            ]);
                                            return;
                                        }
                                    }
                                    
                                    // فحص شرط اليوزر المتغير
                                    if (!empty($r["variable_username_pattern"])) {
                                        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
                                        if (!$userInfo || !$userInfo["ok"]) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ خطأ في التحقق من بياناتك."
                                            ]);
                                            return;
                                        }
                                        $username = $userInfo["result"]["username"] ?? "";
                                        $pattern = $r["variable_username_pattern"];
                                        
                                        if (empty($username)) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ يجب أن يكون يوزرك يطابق النمط المطلوب."
                                            ]);
                                            return;
                                        }
                                        
                                        // تحويل النمط إلى regex
                                        $patternRegex = preg_replace("/@متغير/", "[a-zA-Z0-9_]+", $pattern);
                                        $patternRegex = ltrim($patternRegex, "@");
                                        $patternRegex = "/^" . str_replace("/", "\\/", preg_quote($patternRegex, "/")) . "$/";
                                        $patternRegex = str_replace("\\[a-zA-Z0-9_\\]\\+", "[a-zA-Z0-9_]+", $patternRegex);
                                        
                                        if (!preg_match($patternRegex, $username)) {
                                            apiRequest("sendMessage", [
                                                "chat_id" => $chatId,
                                                "text" => "❗ يجب أن يكون يوزرك يطابق النمط المطلوب."
                                            ]);
                                            return;
                                        }
                                    }
                                    
                                    // التحقق من المشاركة المكررة
                                    if (in_array($userId, $r["participants"])) {
                                        apiRequest("sendMessage", [
                                            "chat_id" => $chatId,
                                            "text" => $texts["already_joined"]
                                        ]);
                                        return;
                                    }
                                    
                                    // إضافة المستخدم للمشاركين
                                    $roulettes[$rouletteId]["participants"][] = $userId;
                                    saveData(ROULETTES_FILE, $roulettes);
                                    updateRouletteMessage($rouletteId);
                                    
                                    $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
                                    if ($userInfo && $userInfo["ok"]) {
                                        $userDisplayName = getUserDisplayName($userInfo["result"]);
                                        $participantsCount = count($roulettes[$rouletteId]["participants"]);
                                        
                                        apiRequest("sendMessage", [
                                            "chat_id" => $r["creator_id"],
                                            "text" => sprintf($texts["new_participant"], $userDisplayName, $userId, $participantsCount)
                                        ]);
                                    }
                                    
                                    apiRequest("sendMessage", [
                                        "chat_id" => $chatId,
                                        "text" => $texts["joined"]
                                    ]);
                                    return;
                                }
                            } else {
                                // الإجابة خاطئة
                                apiRequest("sendMessage", [
                                    "chat_id" => $chatId,
                                    "text" => $texts["verification_failed"]
                                ]);
                                return;
                            }
                        }
                        break;
                    }
                }
            }
        }
        
        // التحقق من تفعيل التذكير
        if (strpos($text, "/start remind_") === 0) {
            $rouletteId = str_replace("/start remind_", "", $text);
            $roulettes = readData(ROULETTES_FILE);
            
            if (isset($roulettes[$rouletteId])) {
                $r = $roulettes[$rouletteId];
                
                // إضافة المستخدم لقائمة التذكير إذا لم يكن موجوداً
                if (!in_array($userId, $r["reminders"])) {
                    $roulettes[$rouletteId]["reminders"][] = $userId;
                    saveData(ROULETTES_FILE, $roulettes);
                }
                
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => "✅ تم تفعيل التذكير! سيتم إشعارك عند الفوز في هذا السحب."
                ]);
                return;
            }
        }
        
        // تم إزالة فحص الاشتراك الإجباري حسب الطلب
        
        // تسجيل المستخدم الجديد
        if (!isset($userStates[$userId])) {
            $userStates[$userId] = [];
            saveData(USERS_FILE, $userStates);
            
            // إرسال إشعار للمالك
            $userInfo = $message["from"];
            sendNewUserNotification($userId, $userInfo);
        }
        
        // التحقق من القنوات الإجبارية قبل إظهار القائمة الرئيسية
        $subscriptionCheck = checkMandatorySubscription($userId);
        if (!$subscriptionCheck["success"]) {
            // لا يزال مفقود بعض القنوات
            $missingList = "";
            $buttons = [];
            foreach ($subscriptionCheck["missing"] as $channel) {
                // استخدام invite link إذا كان متوفراً (للقنوات الخاصة)
                if (!empty($channel["invite_link"])) {
                    $channelLink = $channel["invite_link"];
                    $displayName = ($channel["type"] == "private") ? "🔒 قناة/مجموعة خاصة" : "@" . ltrim($channel["username"], "@");
                    $missingList .= "📢 " . $displayName . "\n";
                    $buttons[] = [["text" => "✅ اشترك هنا", "url" => $channelLink]];
                } else if (!empty($channel["username"])) {
                    // قناة عامة
                    $channelLink = "https://t.me/" . ltrim($channel["username"], "@");
                    $missingList .= "📢 @" . ltrim($channel["username"], "@") . "\n";
                    $buttons[] = [["text" => "✅ اشترك @" . ltrim($channel["username"], "@"), "url" => $channelLink]];
                } else {
                    // قناة خاصة بدون invite link
                    $displayName = "🔒 قناة/مجموعة خاصة";
                    $missingList .= "📢 " . $displayName . "\n";
                }
            }
            $buttons[] = [["text" => "✅ تحقق من الاشتراك", "callback" => "check_subscription"]];
            
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => sprintf($texts["must_subscribe"], $missingList),
                "reply_markup" => buildKeyboard($buttons, true)
            ]);
            return;
        }
        
        $startMessage = $texts["start"];
        
        if ($userId == BOT_OWNER_ID) {
            $startMessage .= "\n\n" . $texts["bot_owner_access"];
        }
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $startMessage,
            "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
        ]);
        return;
    }
    
    $userStates = readData(USERS_FILE);
    $currentState = $userStates[$userId]["state"] ?? "";
    
    switch ($currentState) {
        case "awaiting_channel_forward":
            handleChannelForward($message, $userId, $chatId, $userStates);
            break;
            
        case "awaiting_private_channel_forward":
            handlePrivateChannelForward($message, $userId, $chatId, $userStates);
            break;
            
        case "awaiting_private_channel_forward_roulette":
            handlePrivateChannelForwardForRoulette($message, $userId, $chatId, $userStates);
            break;
            
        case "awaiting_channel_username":
            handleChannelUsername($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_group_id_or_link":
            handleGroupIdOrLink($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_roulette_text":
            handleRouletteText($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_conditional_channel_link":
            handleConditionalChannelLink($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_conditional_channel_2_link":
            handleConditionalChannel2Link($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_conditional_channel_3_link":
            handleConditionalChannel3Link($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_conditional_channel_4_link":
            handleConditionalChannel4Link($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_conditional_channel_5_link":
            handleConditionalChannel5Link($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_conditional_group_link":
            handleConditionalGroupLink($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_winner_count":
            handleWinnerCount($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_boost_channel_link":
            handleBoostChannelLink($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_vote_link":
            handleVoteLink($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_variable_username":
            handleVariableUsername($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_admin_id":
            handleAdminIdInput($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_mandatory_channel":
            handleMandatoryChannelInput($message, $userId, $chatId, $userStates, $text);
            break;
            
        case "awaiting_message_to_users":
            handleMessageToUsers($message, $userId, $chatId, $userStates);
            break;
            
        case "awaiting_message_to_chats":
            handleMessageToChats($message, $userId, $chatId, $userStates);
            break;
            
        default:
            // في المجموعات لا نرسل رسالة "invalid_command"
            $chatType = $message["chat"]["type"] ?? "";
            if (!in_array($chatType, ["group", "supergroup"])) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["invalid_command"],
                    "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
                ]);
            }
    }
}

// دالة جديدة لمعالجة اسم المستخدم للقناة
function handleChannelUsername($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $channelLink = trim($text);
    $channelId = null;
    $channelUsername = null;
    
    if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", $channelLink, $matches)) {
        $channelUsername = "@".$matches[1];
        
        $response = apiRequest("getChat", ["chat_id" => $channelUsername]);
        if ($response && $response["ok"] && in_array($response["result"]["type"], ["channel", "group", "supergroup"])) {
            $channelId = $response["result"]["id"];
            $chatType = $response["result"]["type"];
            $channelUsername = $response["result"]["username"] ?? $channelUsername;
            
            // التحقق من أن البوت مشرف في القناة أو عضو في المجموعة
            $botId = explode(":", BOT_TOKEN)[0];
            $adminCheck = apiRequest("getChatMember", [
                "chat_id" => $channelId,
                "user_id" => $botId
            ]);
            
            if ($chatType == "channel") {
                // للقنوات يجب أن يكون مشرف
                if (!$adminCheck || !$adminCheck["ok"] || !in_array($adminCheck["result"]["status"], ["administrator", "creator"])) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => $texts["channel_not_admin"]
                    ]);
                    return;
                }
            } else {
                // للمجموعات، يجب أن يكون البوت عضو على الأقل
                if (!$adminCheck || !$adminCheck["ok"]) {
                    apiRequest("sendMessage", [
                        "chat_id" => $chatId,
                        "text" => "⚠️ البوت ليس عضو في هذه المجموعة. يرجى إضافة البوت إلى المجموعة أولاً."
                    ]);
                    return;
                }
            }
            
            // إضافة القناة إلى قائمة المستخدم
            if (addUserChannel($userId, $channelId, $channelUsername)) {
                unset($userStates[$userId]["state"]);
                saveData(USERS_FILE, $userStates);
                
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => sprintf($texts["channel_added"], $channelUsername),
                    "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
                ]);
            } else {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["channel_already_exists"]
                ]);
            }
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
        }
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["invalid_link"]
        ]);
    }
}

// دالة معالجة معرف المجموعة أو رابط المجموعة الخاصة
function handleGroupIdOrLink($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $channelId = null;
    $channelUsername = null;
    
    // التحقق من إعادة التوجيه أولاً
    if (isset($message["forward_from_chat"])) {
        $forwardChat = $message["forward_from_chat"];
        $chatType = $forwardChat["type"] ?? "";
        
        if (in_array($chatType, ["group", "supergroup"])) {
            $channelId = $forwardChat["id"];
            $channelUsername = $forwardChat["username"] ?? ("المجموعة " . $channelId);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❗ يرجى إعادة توجيه رسالة من مجموعة وليس قناة."
            ]);
            return;
        }
    } 
    // التحقق من المعرف (Group ID) - رقم سالب
    else if (preg_match("/^-?\d+$/", trim($text))) {
        $groupId = (int)trim($text);
        // المعرف يجب أن يكون سالباً للمجموعات
        if ($groupId > 0) {
            $groupId = -$groupId;
        }
        
        // محاولة الحصول على معلومات المجموعة
        $response = apiRequest("getChat", ["chat_id" => $groupId]);
        if ($response && $response["ok"] && in_array($response["result"]["type"], ["group", "supergroup"])) {
            $channelId = $response["result"]["id"];
            $channelUsername = $response["result"]["username"] ?? ("المجموعة " . $channelId);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❗ لم أتمكن من الوصول إلى هذه المجموعة.\n\n⚠️ تأكد من:\n1️⃣ إضافة البوت إلى المجموعة\n2️⃣ أن البوت عضو في المجموعة\n3️⃣ أن المعرف صحيح"
            ]);
            return;
        }
    }
    // التحقق من رابط المجموعة الخاصة
    else if (preg_match("/^(?:https?:\/\/)?(?:t\.me\/joinchat\/|t\.me\/\+)([a-zA-Z0-9_-]+)/", trim($text), $matches)) {
        // للروابط الخاصة، نحتاج إلى أن يضيف المستخدم البوت أولاً
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⚠️ للروابط الخاصة:\n\n1️⃣ أضف البوت إلى المجموعة أولاً\n2️⃣ ثم أعد توجيه رسالة من المجموعة\n\nأو أرسل معرف المجموعة مباشرة (Group ID)"
        ]);
        return;
    }
    // التحقق من username المجموعة العامة
    else if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", trim($text), $matches)) {
        $channelUsername = "@".$matches[1];
        $response = apiRequest("getChat", ["chat_id" => $channelUsername]);
        if ($response && $response["ok"] && in_array($response["result"]["type"], ["group", "supergroup"])) {
            $channelId = $response["result"]["id"];
            $channelUsername = $response["result"]["username"] ?? $channelUsername;
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
            return;
        }
    }
    else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ الرابط أو المعرف غير صحيح.\n\n💡 أرسل:\n• معرف المجموعة (مثل: -1001234567890)\n• أو أعد توجيه رسالة من المجموعة"
        ]);
        return;
    }
    
    // التحقق من أن البوت عضو في المجموعة
    $botId = explode(":", BOT_TOKEN)[0];
    $adminCheck = apiRequest("getChatMember", [
        "chat_id" => $channelId,
        "user_id" => $botId
    ]);
    
    if (!$adminCheck || !$adminCheck["ok"]) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⚠️ البوت ليس عضو في هذه المجموعة.\n\nيرجى إضافة البوت إلى المجموعة أولاً."
        ]);
        return;
    }
    
    // إضافة المجموعة إلى قائمة المستخدم
    if (addUserChannel($userId, $channelId, $channelUsername)) {
        unset($userStates[$userId]["state"]);
        saveData(USERS_FILE, $userStates);
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => sprintf($texts["channel_added"], $channelUsername),
            "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
        ]);
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["channel_already_exists"]
        ]);
    }
}

// دوال معالجة الاستدعاءات المعدلة
function processCallbackQuery($update) {
    global $texts;
    
    $callback = $update["callback_query"];
    $userId = $callback["from"]["id"];
    $messageId = $callback["message"]["message_id"];
    $chatId = $callback["message"]["chat"]["id"];
    $data = $callback["data"];
    
    // حفظ callback_id للاستخدام في الدوال
    $GLOBALS["callback_id"] = $callback["id"];
    
    $userStates = readData(USERS_FILE);
    $roulettes = readData(ROULETTES_FILE);
    $bannedUsers = readData(BANNED_USERS_FILE);
    
    switch (true) {
        case $data == "back_to_main_menu":
            handleBackToMainMenu($userId, $chatId, $messageId, $userStates);
            break;
            
        case $data == "create_roulette":
            handleCreateRoulette($userId, $chatId, $messageId, $userStates);
            break;
            
        case $data == "my_channels":
            handleMyChannels($userId, $chatId, $messageId);
            break;
            
        case $data == "manage_channels":
            handleManageChannels($userId, $chatId, $messageId);
            break;
            
        case $data == "back_to_channels_management":
            handleBackToChannelsManagement($userId, $chatId, $messageId);
            break;
            
        case $data == "add_channel":
            handleAddChannel($userId, $chatId, $userStates);
            break;
            
        case $data == "add_group":
            handleAddGroup($userId, $chatId, $userStates);
            break;
            
        case $data == "add_private_channel":
            handleAddPrivateChannel($userId, $chatId, $userStates);
            break;
            
        case $data == "delete_channel":
            handleDeleteChannel($userId, $chatId, $messageId);
            break;
            
        case strpos($data, "select_channel_") === 0:
            $channelId = substr($data, strlen("select_channel_"));
            handleSelectChannel($userId, $chatId, $channelId, $userStates);
            break;
            
        case strpos($data, "confirm_delete_channel_") === 0:
            $channelId = substr($data, strlen("confirm_delete_channel_"));
            handleConfirmDeleteChannel($userId, $chatId, $messageId, $channelId);
            break;
            
        case $data == "select_type_normal":
            handleSelectRouletteType($userId, $chatId, $messageId, "normal", $userStates);
            break;
            
        case $data == "select_type_anti_spam":
            handleSelectRouletteType($userId, $chatId, $messageId, "anti_spam", $userStates);
            break;
            
        // باقي الحالات تبقى كما هي
        case $data == "prompt_conditional_channel":
            handlePromptConditionalChannel($userId, $chatId, $messageId);
            break;
            
        case $data == "prompt_conditional_group":
            handlePromptConditionalGroup($userId, $chatId, $messageId);
            break;
            
        case $data == "send_conditional_channel_link_prompt":
            handleSendConditionalChannelLinkPrompt($userId, $chatId, $userStates);
            break;
            
        case $data == "prompt_conditional_channel_2":
            handleSendConditionalChannel2LinkPrompt($userId, $chatId, $userStates);
            break;
            
        case $data == "prompt_conditional_channel_3":
            handleSendConditionalChannel3LinkPrompt($userId, $chatId, $userStates);
            break;
            
        case $data == "prompt_conditional_channel_4":
            handleSendConditionalChannel4LinkPrompt($userId, $chatId, $userStates);
            break;
            
        case $data == "prompt_conditional_channel_5":
            handleSendConditionalChannel5LinkPrompt($userId, $chatId, $userStates);
            break;
            
        case $data == "send_conditional_group_link_prompt":
            handleSendConditionalGroupLinkPrompt($userId, $chatId, $userStates);
            break;
            
        case $data == "skip_conditional_channel":
            handleSkipConditionalChannel($userId, $chatId, $userStates);
            break;
            
        case $data == "add_second_condition":
            handleAddSecondCondition($userId, $chatId, $messageId);
            break;
            
        case $data == "prompt_boost_channel":
            handlePromptBoostChannel($userId, $chatId, $userStates);
            break;
            
        case $data == "prompt_vote_link":
            handlePromptVoteLink($userId, $chatId, $userStates);
            break;
            
        case $data == "toggle_premium_requirement":
            handleTogglePremiumRequirement($userId, $chatId, $userStates);
            break;
            
        case $data == "toggle_tripartite_username_requirement":
            handleToggleTripartiteUsernameRequirement($userId, $chatId, $userStates);
            break;
            
        case strpos($data, "join_roulette_") === 0:
            $rouletteId = substr($data, strlen("join_roulette_"));
            handleJoinRoulette($userId, $callback, $rouletteId, $roulettes, $bannedUsers);
            break;
            
        case strpos($data, "toggle_participation_") === 0:
            $rouletteId = substr($data, strlen("toggle_participation_"));
            handleToggleParticipation($userId, $callback, $rouletteId, $roulettes);
            break;
            
        case strpos($data, "start_draw_") === 0:
            $rouletteId = substr($data, strlen("start_draw_"));
            handleStartDraw($userId, $callback, $rouletteId, $roulettes);
            break;
            
        case strpos($data, "view_participants_") === 0:
            $rouletteId = substr($data, strlen("view_participants_"));
            handleViewParticipants($userId, $callback, $rouletteId, $roulettes);
            break;
            
        case strpos($data, "exclude_participant_") === 0:
            $parts = explode("_", $data);
            $rouletteId = $parts[3];
            $participantId = $parts[4];
            handleExcludeParticipant($userId, $callback, $rouletteId, $participantId, $roulettes, $bannedUsers);
            break;
            
        case $data == "remind_me_global_info":
            handleRemindMeGlobalInfo($userId, $chatId, $messageId);
            break;
            
        case $data == "admin_panel":
            handleAdminPanel($userId, $chatId, $messageId);
            break;
            
        case $data == "admin_stats":
            handleAdminStats($userId, $chatId, $messageId);
            break;
            
        case $data == "admin_add":
            handleAdminAdd($userId, $chatId, $userStates);
            break;
            
        case $data == "admin_remove":
            handleAdminRemove($userId, $chatId, $userStates);
            break;
            
        case $data == "admin_notify_on":
            handleAdminNotifyOn($userId, $chatId, $messageId);
            break;
            
        case $data == "admin_notify_off":
            handleAdminNotifyOff($userId, $chatId, $messageId);
            break;
            
        case $data == "admin_mandatory_channels":
            handleAdminMandatoryChannels($userId, $chatId, $messageId);
            break;
            
        case $data == "admin_send_to_all_users":
            handleAdminSendToAllUsers($userId, $chatId, $userStates);
            break;
            
        case $data == "admin_send_to_all_chats":
            handleAdminSendToAllChats($userId, $chatId, $userStates);
            break;
            
        case $data == "admin_kick_all":
            handleAdminKickAll($userId, $chatId, $messageId);
            break;
            
        case $data == "admin_leave_all":
            handleAdminLeaveAll($userId, $chatId, $messageId);
            break;
            
        case $data == "check_subscription":
            handleCheckSubscription($userId, $chatId, $messageId);
            break;
            
        case strpos($data, "add_mandatory_channel_") === 0:
            $channelType = substr($data, strlen("add_mandatory_channel_"));
            handleAddMandatoryChannelPrompt($userId, $chatId, $userStates, $channelType);
            break;
            
        case strpos($data, "remove_mandatory_channel_") === 0:
            $channelId = substr($data, strlen("remove_mandatory_channel_"));
            handleRemoveMandatoryChannel($userId, $chatId, $messageId, $channelId);
            break;
            
        case strpos($data, "remove_admin_") === 0:
            $adminId = intval(substr($data, strlen("remove_admin_")));
            handleRemoveAdminById($userId, $chatId, $adminId);
            break;
            
        default:
            apiRequest("editMessageText", [
                "chat_id" => $chatId,
                "message_id" => $messageId,
                "text" => $texts["invalid_command"],
                "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
            ]);
    }
}

// معالجة تحديث my_chat_member لمراقبة مغادرة المستخدمين
function processMyChatMember($update) {
    global $texts;
    
    $myChatMember = $update["my_chat_member"];
    $member = $myChatMember["new_chat_member"];
    $userId = $myChatMember["from"]["id"];
    $chatId = $myChatMember["chat"]["id"];
    
    // هذا الحدث خاص بالبوت فقط، نتجاهله
    return;
}


// دوال جديدة لإدارة القنوات
function handleMyChannels($userId, $chatId, $messageId) {
    global $texts;
    
    $userChannels = getUserChannels($userId);
    
    if (empty($userChannels)) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["no_channels"],
            "reply_markup" => buildKeyboard(channelsManagementKeyboard(), true)
        ]);
    } else {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["select_channel"],
            "reply_markup" => buildKeyboard(myChannelsKeyboard($userId), true)
        ]);
    }
}

function handleManageChannels($userId, $chatId, $messageId) {
    global $texts;
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => "🔧 إدارة القنوات - اختر الإجراء المطلوب:",
        "reply_markup" => buildKeyboard(channelsManagementKeyboard(), true)
    ]);
}

function handleBackToChannelsManagement($userId, $chatId, $messageId) {
    handleManageChannels($userId, $chatId, $messageId);
}

function handleAddChannel($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_channel_username";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["enter_channel_username"]
    ]);
}

function handleAddGroup($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_group_id_or_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => "➕ إضافة كروب:\n\n📝 أرسل معرف المجموعة (Group ID) أو رابط المجموعة الخاصة:\n\n💡 أمثلة:\n• المعرف: -1001234567890\n• الرابط: https://t.me/joinchat/ABC123...\n• أو أعد توجيه رسالة من المجموعة"
    ]);
}

function handleAddPrivateChannel($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_private_channel_forward_roulette";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["forward_message"]
    ]);
}

function handleDeleteChannel($userId, $chatId, $messageId) {
    global $texts;
    
    $userChannels = getUserChannels($userId);
    
    if (empty($userChannels)) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["no_channels"],
            "reply_markup" => buildKeyboard(channelsManagementKeyboard(), true)
        ]);
    } else {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => "🗑️ اختر القناة/المجموعة التي تريد حذفها:",
            "reply_markup" => buildKeyboard(deleteChannelsKeyboard($userId), true)
        ]);
    }
}

function handleSelectChannel($userId, $chatId, $channelId, &$userStates) {
    global $texts;
    
    $userChannels = getUserChannels($userId);
    
    if (!isset($userChannels[$channelId])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["channel_not_found"]
        ]);
        return;
    }
    
    $channelInfo = $userChannels[$channelId];
    
    // التحقق من أن المستخدم أدمن أو مالك في القناة
    $memberCheck = apiRequest("getChatMember", [
        "chat_id" => $channelId,
        "user_id" => $userId
    ]);
    
    if (!$memberCheck || !$memberCheck["ok"]) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ حدث خطأ في التحقق من صلاحياتك في القناة."
        ]);
        return;
    }
    
    $memberStatus = $memberCheck["result"]["status"];
    if (!in_array($memberStatus, ["administrator", "creator"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ يجب أن تكون أدمن أو مالك في القناة لإنشاء روليت.\n\nالقناة: @" . ltrim($channelInfo["username"], "@")
        ]);
        return;
    }
    
    // حفظ القناة المختارة في البيانات المؤقتة
    $tempData = readTempFile($userId);
    if (!$tempData) {
        $tempData = [];
    }
    
    $tempData["selected_channel_id"] = $channelId;
    $tempData["selected_channel_username"] = $channelInfo["username"];
    
    if (!writeTempFile($userId, $tempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    // الانتقال لاختيار نوع الروليت
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["select_roulette_type"],
        "reply_markup" => buildKeyboard(rouletteTypeKeyboard(), true)
    ]);
}

function handleSelectRouletteType($userId, $chatId, $messageId, $type, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $userTempData["roulette_type"] = $type;
    
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    // الانتقال لكتابة نص الروليت
    $userStates[$userId]["state"] = "awaiting_roulette_text";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["roulette_text_prompt"]
    ]);
}

function handleConfirmDeleteChannel($userId, $chatId, $messageId, $channelId) {
    global $texts;
    
    $userChannels = getUserChannels($userId);
    
    if (!isset($userChannels[$channelId])) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["channel_not_found"],
            "reply_markup" => buildKeyboard(channelsManagementKeyboard(), true)
        ]);
        return;
    }
    
    $channelUsername = $userChannels[$channelId]["username"];
    
    if (removeUserChannel($userId, $channelId)) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => sprintf($texts["channel_removed"], $channelUsername),
            "reply_markup" => buildKeyboard(channelsManagementKeyboard(), true)
        ]);
    } else {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => "❗ فشل في حذف القناة. حاول مرة أخرى.",
            "reply_markup" => buildKeyboard(channelsManagementKeyboard(), true)
        ]);
    }
}

// تعديل دالة إنشاء الروليت
function handleCreateRoulette($userId, $chatId, $messageId, &$userStates) {
    global $texts;
    
    $userChannels = getUserChannels($userId);
    
    if (empty($userChannels)) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["no_channels"],
            "reply_markup" => buildKeyboard(channelsManagementKeyboard(), true)
        ]);
        return;
    }
    
    // عرض قائمة القنوات للاختيار
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["select_channel"],
        "reply_markup" => buildKeyboard(myChannelsKeyboard($userId), true)
    ]);
}

// باقي الدوال تبقى كما هي مع تعديلات طفيفة
function handleBackToMainMenu($userId, $chatId, $messageId, &$userStates) {
    global $texts;
    
    unset($userStates[$userId]["state"]);
    saveData(USERS_FILE, $userStates);
    
    $startMessage = $texts["start"];
    if ($userId == BOT_OWNER_ID) {
        $startMessage .= "\n\n" . $texts["bot_owner_access"];
    }
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $startMessage,
        "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
    ]);
}

// باقي الدوال (handleChooseStyleInstructions, handlePromptConditionalChannel, etc.)
// تبقى كما هي مع تعديلات طفيفة لاستخدام النظام الجديد

// الدوال المتبقية (نفس الدوال السابقة مع تعديلات طفيفة)
function handleChooseStyleInstructions($userId, $chatId, $messageId, &$userStates, $callback) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["temp_file_corrupted"],
            "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
        ]);
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_roulette_text";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["roulette_text_prompt"]
    ]);
}

function handlePromptConditionalChannel($userId, $chatId, $messageId) {
    global $texts;
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["conditional_channel_question"],
        "reply_markup" => buildKeyboard(conditionalChannelKeyboard(), true)
    ]);
}

function handlePromptConditionalGroup($userId, $chatId, $messageId) {
    global $texts;
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["conditional_group_question"],
        "reply_markup" => buildKeyboard(conditionalGroupKeyboard(), true)
    ]);
}

function handleSendConditionalChannelLinkPrompt($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_conditional_channel_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["send_conditional_link"]
    ]);
}

function handleSendConditionalGroupLinkPrompt($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_conditional_group_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["send_conditional_group_link"]
    ]);
}

function handleSendConditionalChannel2LinkPrompt($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    // التحقق من وجود القناة الشرطية الأولى
    if (empty($userTempData["conditional_channel_id"]) && empty($userTempData["conditional_channel_username"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["must_add_first_conditional"]
        ]);
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_conditional_channel_2_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["send_conditional_channel_2_link"]
    ]);
}

function handleSendConditionalChannel3LinkPrompt($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    // التحقق من عدد القنوات
    $channelsCount = 0;
    if (!empty($userTempData["conditional_channel_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_2_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_3_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_4_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_5_id"])) $channelsCount++;
    
    if ($channelsCount >= 5) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["max_conditional_channels_reached"]
        ]);
        return;
    }
    
    // التحقق من وجود القناة الشرطية الثانية
    if (empty($userTempData["conditional_channel_2_id"]) && empty($userTempData["conditional_channel_2_username"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["must_add_previous_conditional"]
        ]);
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_conditional_channel_3_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["send_conditional_channel_3_link"]
    ]);
}

function handleSendConditionalChannel4LinkPrompt($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    // التحقق من عدد القنوات
    $channelsCount = 0;
    if (!empty($userTempData["conditional_channel_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_2_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_3_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_4_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_5_id"])) $channelsCount++;
    
    if ($channelsCount >= 5) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["max_conditional_channels_reached"]
        ]);
        return;
    }
    
    // التحقق من وجود القناة الشرطية الثالثة
    if (empty($userTempData["conditional_channel_3_id"]) && empty($userTempData["conditional_channel_3_username"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["must_add_previous_conditional"]
        ]);
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_conditional_channel_4_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["send_conditional_channel_4_link"]
    ]);
}

function handleSendConditionalChannel5LinkPrompt($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    // التحقق من عدد القنوات
    $channelsCount = 0;
    if (!empty($userTempData["conditional_channel_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_2_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_3_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_4_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_5_id"])) $channelsCount++;
    
    if ($channelsCount >= 5) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["max_conditional_channels_reached"]
        ]);
        return;
    }
    
    // التحقق من وجود القناة الشرطية الرابعة
    if (empty($userTempData["conditional_channel_4_id"]) && empty($userTempData["conditional_channel_4_username"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["must_add_previous_conditional"]
        ]);
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_conditional_channel_5_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["send_conditional_channel_5_link"]
    ]);
}

function handleAddSecondCondition($userId, $chatId, $messageId) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    // التحقق من وجود القناة الشرطية الأولى
    if (empty($userTempData["conditional_channel_id"]) && empty($userTempData["conditional_channel_username"])) {
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => $texts["must_add_first_conditional"]
        ]);
        return;
    }
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["add_second_condition_question"],
        "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
    ]);
}

function handleSkipConditionalChannel($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_winner_count";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["enter_winners"]
    ]);
}

function handleRouletteText($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $userTempData["roulette_text"] = $text;
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["text_saved"],
        "reply_markup" => buildKeyboard(rouletteOptionsKeyboard(), true)
    ]);
}

function handleConditionalChannelLink($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $channelLink = trim($text);
    $channelId = null;
    $channelUsername = null;
    
    if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", $channelLink, $matches)) {
        $channelUsername = "@".$matches[1];
        
        $response = apiRequest("getChat", ["chat_id" => $channelUsername]);
        if ($response && $response["ok"] && $response["result"]["type"] == "channel") {
            $channelId = $response["result"]["id"];
            $channelUsername = $response["result"]["username"] ?? $channelUsername;
            
            $userTempData["conditional_channel_id"] = $channelId;
            $userTempData["conditional_channel_username"] = $channelUsername;
            
            if (!writeTempFile($userId, $userTempData)) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["file_error"]
                ]);
                return;
            }
            
            unset($userStates[$userId]["state"]);
            saveData(USERS_FILE, $userStates);
            
            // إرسال رسالة تأكيد إضافة الشرط
            $conditionName = $channelUsername;
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
                "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
        }
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["invalid_link"]
        ]);
    }
}

function handleConditionalChannel2Link($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    // التحقق من وجود القناة الشرطية الأولى
    if (empty($userTempData["conditional_channel_id"]) && empty($userTempData["conditional_channel_username"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["must_add_first_conditional"]
        ]);
        return;
    }
    
    $channelLink = trim($text);
    $channelId = null;
    $channelUsername = null;
    
    if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", $channelLink, $matches)) {
        $channelUsername = "@".$matches[1];
        
        $response = apiRequest("getChat", ["chat_id" => $channelUsername]);
        if ($response && $response["ok"] && $response["result"]["type"] == "channel") {
            $channelId = $response["result"]["id"];
            $channelUsername = $response["result"]["username"] ?? $channelUsername;
            
            $userTempData["conditional_channel_2_id"] = $channelId;
            $userTempData["conditional_channel_2_username"] = $channelUsername;
            
            if (!writeTempFile($userId, $userTempData)) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["file_error"]
                ]);
                return;
            }
            
            unset($userStates[$userId]["state"]);
            saveData(USERS_FILE, $userStates);
            
            // إرسال رسالة تأكيد إضافة الشرط
            $conditionName = $channelUsername;
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
                "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
        }
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["invalid_link"]
        ]);
    }
}

// دالة عامة لمعالجة القنوات الشرطية (3، 4، 5)
function handleConditionalChannelNLink($message, $userId, $chatId, &$userStates, $text, $channelNumber) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    // التحقق من عدد القنوات
    $channelsCount = 0;
    if (!empty($userTempData["conditional_channel_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_2_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_3_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_4_id"])) $channelsCount++;
    if (!empty($userTempData["conditional_channel_5_id"])) $channelsCount++;
    
    if ($channelsCount >= 5) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["max_conditional_channels_reached"]
        ]);
        return;
    }
    
    // التحقق من وجود القناة السابقة
    $prevChannelKey = $channelNumber > 1 ? "conditional_channel_" . ($channelNumber - 1) . "_id" : "conditional_channel_id";
    if (empty($userTempData[$prevChannelKey])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["must_add_previous_conditional"]
        ]);
        return;
    }
    
    $channelLink = trim($text);
    $channelId = null;
    $channelUsername = null;
    
    if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", $channelLink, $matches)) {
        $channelUsername = "@".$matches[1];
        
        $response = apiRequest("getChat", ["chat_id" => $channelUsername]);
        if ($response && $response["ok"] && $response["result"]["type"] == "channel") {
            $channelId = $response["result"]["id"];
            $channelUsername = $response["result"]["username"] ?? $channelUsername;
            
            $idKey = "conditional_channel_" . $channelNumber . "_id";
            $usernameKey = "conditional_channel_" . $channelNumber . "_username";
            
            $userTempData[$idKey] = $channelId;
            $userTempData[$usernameKey] = $channelUsername;
            
            if (!writeTempFile($userId, $userTempData)) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["file_error"]
                ]);
                return;
            }
            
            unset($userStates[$userId]["state"]);
            saveData(USERS_FILE, $userStates);
            
            // إرسال رسالة تأكيد إضافة الشرط
            $conditionName = $channelUsername;
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
                "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
        }
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["invalid_link"]
        ]);
    }
}

function handleConditionalChannel3Link($message, $userId, $chatId, &$userStates, $text) {
    handleConditionalChannelNLink($message, $userId, $chatId, $userStates, $text, 3);
}

function handleConditionalChannel4Link($message, $userId, $chatId, &$userStates, $text) {
    handleConditionalChannelNLink($message, $userId, $chatId, $userStates, $text, 4);
}

function handleConditionalChannel5Link($message, $userId, $chatId, &$userStates, $text) {
    handleConditionalChannelNLink($message, $userId, $chatId, $userStates, $text, 5);
}

function handleConditionalGroupLink($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $groupId = null;
    $groupUsername = null;
    $groupTitle = null;
    $groupInviteLink = null;
    
    // التحقق من إعادة التوجيه أولاً
    if (isset($message["forward_from_chat"])) {
        $forwardChat = $message["forward_from_chat"];
        $chatType = $forwardChat["type"] ?? "";
        
        if (in_array($chatType, ["group", "supergroup"])) {
            $groupId = $forwardChat["id"];
            $groupTitle = $forwardChat["title"] ?? ("المجموعة " . $groupId);
            $groupUsername = $forwardChat["username"] ?? null;
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❗ يرجى إعادة توجيه رسالة من مجموعة وليس قناة."
            ]);
            return;
        }
    } 
    // التحقق من المعرف (Group ID) - رقم سالب
    else if (preg_match("/^-?\d+$/", trim($text))) {
        $groupIdValue = (int)trim($text);
        // المعرف يجب أن يكون سالباً للمجموعات
        if ($groupIdValue > 0) {
            $groupIdValue = -$groupIdValue;
        }
        
        // محاولة الحصول على معلومات المجموعة
        $response = apiRequest("getChat", ["chat_id" => $groupIdValue]);
        if ($response && $response["ok"] && in_array($response["result"]["type"], ["group", "supergroup"])) {
            $groupId = $response["result"]["id"];
            $groupTitle = $response["result"]["title"] ?? ("المجموعة " . $groupId);
            $groupUsername = $response["result"]["username"] ?? null;
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❗ لم أتمكن من الوصول إلى هذه المجموعة.\n\n⚠️ تأكد من:\n1️⃣ إضافة البوت إلى المجموعة\n2️⃣ أن البوت عضو في المجموعة\n3️⃣ أن المعرف صحيح"
            ]);
            return;
        }
    }
    // التحقق من username المجموعة العامة
    else if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", trim($text), $matches)) {
        $groupUsername = "@".$matches[1];
        $response = apiRequest("getChat", ["chat_id" => $groupUsername]);
        if ($response && $response["ok"] && in_array($response["result"]["type"], ["group", "supergroup"])) {
            $groupId = $response["result"]["id"];
            $groupTitle = $response["result"]["title"] ?? ("المجموعة " . $groupId);
            $groupUsername = $response["result"]["username"] ?? $groupUsername;
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
            return;
        }
    }
    // التحقق من رابط المجموعة الخاصة
    else if (preg_match("/^(?:https?:\/\/)?(?:t\.me\/joinchat\/|t\.me\/\+)([a-zA-Z0-9_-]+)/", trim($text), $matches)) {
        $inviteLink = trim($text);
        // محاولة الانضمام أو الحصول على معلومات من الرابط
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⚠️ للروابط الخاصة:\n\n1️⃣ أضف البوت إلى المجموعة أولاً\n2️⃣ ثم أعد توجيه رسالة من المجموعة أو أرسل معرف المجموعة (Group ID)"
        ]);
        return;
    }
    else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ الرابط أو المعرف غير صحيح.\n\n💡 أرسل:\n• معرف المجموعة (مثل: -1001234567890)\n• أو أعد توجيه رسالة من المجموعة"
        ]);
        return;
    }
    
    // التحقق من أن البوت عضو في المجموعة
    $botId = explode(":", BOT_TOKEN)[0];
    $adminCheck = apiRequest("getChatMember", [
        "chat_id" => $groupId,
        "user_id" => $botId
    ]);
    
    if (!$adminCheck || !$adminCheck["ok"]) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⚠️ البوت ليس عضو في هذه المجموعة.\n\nيرجى إضافة البوت إلى المجموعة أولاً."
        ]);
        return;
    }
    
    // محاولة الحصول على رابط الدعوة إذا كان البوت مشرف
    if ($adminCheck["result"]["status"] == "administrator" || $adminCheck["result"]["status"] == "creator") {
        $inviteLinkResponse = apiRequest("exportChatInviteLink", ["chat_id" => $groupId]);
        if ($inviteLinkResponse && $inviteLinkResponse["ok"]) {
            $groupInviteLink = $inviteLinkResponse["result"];
        }
    }
    
    // إذا لم يكن هناك username، استخدم invite link أو أنشئ رابط باستخدام المعرف
    if (empty($groupUsername)) {
        if ($groupInviteLink) {
            $groupLink = $groupInviteLink;
        } else {
            // إذا لم يكن هناك invite link، لا يمكننا إنشاء رابط مباشر
            // سنستخدم المعرف ولكن لن يعمل كرابط
            $groupLink = "tg://openmessage?chat_id=" . $groupId;
        }
    } else {
        $groupLink = "https://t.me/" . ltrim($groupUsername, "@");
    }
    
    $userTempData["conditional_group_id"] = $groupId;
    $userTempData["conditional_group_username"] = $groupUsername;
    $userTempData["conditional_group_title"] = $groupTitle;
    $userTempData["conditional_group_link"] = $groupLink;
    
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    unset($userStates[$userId]["state"]);
    saveData(USERS_FILE, $userStates);
    
    // إرسال رسالة تأكيد إضافة الشرط
    $conditionName = !empty($groupUsername) ? $groupUsername : $groupTitle;
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
        "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
    ]);
}

function handleWinnerCount($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $winnersCount = intval($text);
    if ($winnersCount <= 0) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["invalid_winners"]
        ]);
        return;
    }
    
    $userTempData["winners_count"] = $winnersCount;
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    unset($userStates[$userId]["state"]);
    saveData(USERS_FILE, $userStates);
    
    publishRoulette($userId);
}

function handlePromptBoostChannel($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_boost_channel_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => "🚀 أرسل رابط قناة التعزيز (مثال: @A_U_D أو https://t.me/A_U_D)\n\n⚠️ تأكد أن البوت أدمن في القناة.\n\n📝 سيتم استخدام رابط التعزيز بصيغة: https://t.me/boost/USERNAME"
    ]);
}

function handleBoostChannelLink($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $channelLink = trim($text);
    $channelId = null;
    $channelUsername = null;
    
    if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", $channelLink, $matches)) {
        $channelUsername = "@".$matches[1];
        
        $response = apiRequest("getChat", ["chat_id" => $channelUsername]);
        if ($response && $response["ok"] && $response["result"]["type"] == "channel") {
            $channelId = $response["result"]["id"];
            $channelUsername = $response["result"]["username"] ?? $channelUsername;
            
            // التحقق من أن البوت أدمن
            $botId = explode(":", BOT_TOKEN)[0];
            $adminCheck = apiRequest("getChatMember", [
                "chat_id" => $channelId,
                "user_id" => $botId
            ]);
            
            if (!$adminCheck || !$adminCheck["ok"] || !in_array($adminCheck["result"]["status"], ["administrator", "creator"])) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => "❗ البوت ليس أدمن في هذه القناة. أضف البوت كمشرف أولاً."
                ]);
                return;
            }
            
            $userTempData["boost_channel_id"] = $channelId;
            $userTempData["boost_channel_username"] = $channelUsername;
            // استخدام رابط التعزيز بصيغة https://t.me/boost/USERNAME
            $userTempData["boost_channel_link"] = "https://t.me/boost/" . ltrim($channelUsername, "@");
            
            if (!writeTempFile($userId, $userTempData)) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["file_error"]
                ]);
                return;
            }
            
            unset($userStates[$userId]["state"]);
            saveData(USERS_FILE, $userStates);
            
            // إرسال رسالة تأكيد إضافة الشرط
            $conditionName = $channelUsername;
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
                "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
        }
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["invalid_link"]
        ]);
    }
}

function handlePromptVoteLink($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_vote_link";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => "🗳️ أرسل رابط التصويت (أي رابط منصة للتصويت على متسابق معين)"
    ]);
}

function handleVoteLink($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $voteLink = trim($text);
    
    if (!filter_var($voteLink, FILTER_VALIDATE_URL)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ الرابط غير صحيح. يرجى إرسال رابط صحيح."
        ]);
        return;
    }
    
    $userTempData["vote_link"] = $voteLink;
    
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    unset($userStates[$userId]["state"]);
    saveData(USERS_FILE, $userStates);
    
    // إرسال رسالة تأكيد إضافة الشرط
    $conditionName = "رابط التصويت";
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
        "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
    ]);
}

function handleTogglePremiumRequirement($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $userTempData["require_premium"] = !($userTempData["require_premium"] ?? false);
    
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    $status = $userTempData["require_premium"] ? "مفعل" : "معطل";
    if ($userTempData["require_premium"]) {
        // إرسال رسالة تأكيد إضافة الشرط
        $conditionName = "حساب مميز";
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
            "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
        ]);
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "✅ شرط الحساب المميز: " . $status,
            "reply_markup" => buildKeyboard(rouletteOptionsKeyboard(), true)
        ]);
    }
}

function handleToggleNFTUsernameRequirement($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $userTempData["require_nft_username"] = !($userTempData["require_nft_username"] ?? false);
    
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    $status = $userTempData["require_nft_username"] ? "مفعل" : "معطل";
    if ($userTempData["require_nft_username"]) {
        // إرسال رسالة تأكيد إضافة الشرط
        $conditionName = "يوزر NFT";
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
            "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
        ]);
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "✅ شرط يوزر NFT: " . $status,
            "reply_markup" => buildKeyboard(rouletteOptionsKeyboard(), true)
        ]);
    }
}

function handleToggleTripartiteUsernameRequirement($userId, $chatId, &$userStates) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $userTempData["require_tripartite_username"] = !($userTempData["require_tripartite_username"] ?? false);
    
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    $status = $userTempData["require_tripartite_username"] ? "مفعل" : "معطل";
    if ($userTempData["require_tripartite_username"]) {
        // إرسال رسالة تأكيد إضافة الشرط
        $conditionName = "يوزر ثلاثي";
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
            "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
        ]);
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "✅ شرط اليوزر الثلاثي: " . $status,
            "reply_markup" => buildKeyboard(rouletteOptionsKeyboard(), true)
        ]);
    }
}

function handlePromptVariableUsername($userId, $chatId, &$userStates) {
    global $texts;
    
    $userStates[$userId]["state"] = "awaiting_variable_username";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => "📝 أرسل نمط اليوزر المطلوب (استخدم @متغير للجزء المتغير)\n\nمثال: @متغير"
    ]);
}

function handleVariableUsername($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    $userTempData = readTempFile($userId);
    if (!$userTempData) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["temp_file_corrupted"]
        ]);
        return;
    }
    
    $pattern = trim($text);
    
    if (empty($pattern)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ النمط غير صحيح."
        ]);
        return;
    }
    
    $userTempData["variable_username_pattern"] = $pattern;
    
    if (!writeTempFile($userId, $userTempData)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    unset($userStates[$userId]["state"]);
    saveData(USERS_FILE, $userStates);
    
    // إرسال رسالة تأكيد إضافة الشرط
    $conditionName = $pattern;
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => sprintf($texts["condition_added"], $conditionName) . "\n\n" . $texts["add_second_condition_question"],
        "reply_markup" => buildKeyboard(addSecondConditionKeyboard($userId), true)
    ]);
}

function handleJoinRoulette($userId, $callback, $rouletteId, $roulettes, $bannedUsers) {
    global $texts;
    
    if (!isset($roulettes[$rouletteId])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "❗ هذا السحب لم يعد موجوداً."
        ]);
        return;
    }
    
    $r = $roulettes[$rouletteId];
    
    if (!$r["active"]) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["stopped"]
        ]);
        return;
    }
    
    if ($userId == $r["creator_id"]) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["creator_join"]
        ]);
        return;
    }
    
    if (isset($bannedUsers[$r["creator_id"]]) && in_array($userId, $bannedUsers[$r["creator_id"]])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["banned"]
        ]);
        return;
    }
    
    if (!empty($r["conditional_channel_id"])) {
        $member = apiRequest("getChatMember", [
            "chat_id" => $r["conditional_channel_id"],
            "user_id" => $userId
        ]);
        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["subscribe_first"],
                "show_alert" => true
            ]);
            // لا ترسل أي رسالة في القناة نهائيًا
            return;
        }
    }
    
    if (!empty($r["conditional_channel_2_id"])) {
        $member = apiRequest("getChatMember", [
            "chat_id" => $r["conditional_channel_2_id"],
            "user_id" => $userId
        ]);
        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["subscribe_first"],
                "show_alert" => true
            ]);
            // لا ترسل أي رسالة في القناة نهائيًا
            return;
        }
    }
    
    if (!empty($r["conditional_channel_3_id"])) {
        $member = apiRequest("getChatMember", [
            "chat_id" => $r["conditional_channel_3_id"],
            "user_id" => $userId
        ]);
        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["subscribe_first"],
                "show_alert" => true
            ]);
            return;
        }
    }
    
    if (!empty($r["conditional_channel_4_id"])) {
        $member = apiRequest("getChatMember", [
            "chat_id" => $r["conditional_channel_4_id"],
            "user_id" => $userId
        ]);
        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["subscribe_first"],
                "show_alert" => true
            ]);
            return;
        }
    }
    
    if (!empty($r["conditional_channel_5_id"])) {
        $member = apiRequest("getChatMember", [
            "chat_id" => $r["conditional_channel_5_id"],
            "user_id" => $userId
        ]);
        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["subscribe_first"],
                "show_alert" => true
            ]);
            return;
        }
    }
    
    if (!empty($r["conditional_group_id"])) {
        $member = apiRequest("getChatMember", [
            "chat_id" => $r["conditional_group_id"],
            "user_id" => $userId
        ]);
        if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["subscribe_first"],
                "show_alert" => true
            ]);
            return;
        }
    }
    
    // فحص شرط تعزيز القناة
    if (!empty($r["boost_channel_id"])) {
        $member = apiRequest("getChatMember", [
            "chat_id" => $r["boost_channel_id"],
            "user_id" => $userId
        ]);
        if (!$member || !$member["ok"]) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ يجب الاشتراك وتعزيز القناة أولاً للمشاركة.\n\n🚀 اضغط على رابط التعزيز في الرسالة.",
                "show_alert" => true
            ]);
            return;
        }
        // التحقق من أن المستخدم عضو في القناة
        $status = $member["result"]["status"] ?? "";
        if (in_array($status, ["left", "kicked"])) {
            $boostLink = !empty($r['boost_channel_link']) ? $r['boost_channel_link'] : 'https://t.me/boost/' . ltrim($r['boost_channel_username'], '@');
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ يجب الاشتراك وتعزيز القناة أولاً للمشاركة.\n\n🚀 اضغط على رابط التعزيز في الرسالة.",
                "show_alert" => true
            ]);
            return;
        }
    }
    
    // فحص شرط الحساب المميز
    if (!empty($r["require_premium"])) {
        $isPremium = false;
        
        // دالة مساعدة للتحقق من Premium من أي مصدر - أكثر مرونة
        $checkPremium = function($userData) {
            if (!is_array($userData) || !array_key_exists("is_premium", $userData)) {
                return false;
            }
            $value = $userData["is_premium"];
            // التحقق من جميع الأشكال الممكنة: true, 1, "true", "1", أو أي قيمة truthy
            if ($value === true || $value === 1 || $value === "true" || $value === "1") {
                return true;
            }
            // التحقق من القيم truthy الأخرى (لكن بحذر)
            if ($value && $value !== false && $value !== 0 && $value !== "false" && $value !== "0") {
                return true;
            }
            return false;
        };
        
        // التحقق من Premium من callback_query.from أولاً (الأكثر دقة)
        if (isset($callback["from"]) && is_array($callback["from"]) && $checkPremium($callback["from"])) {
            $isPremium = true;
        }
        
        // إذا لم يكن متوفر في callback، نستخدم getChat
        if (!$isPremium) {
            $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
            if ($userInfo && $userInfo["ok"] && isset($userInfo["result"]) && is_array($userInfo["result"])) {
                if ($checkPremium($userInfo["result"])) {
                    $isPremium = true;
                }
            }
        }
        
        // محاولة أخرى باستخدام getChatMember من أي قناة متاحة
        if (!$isPremium) {
            $channelsToCheck = [];
            if (!empty($r["main_channel_id"])) $channelsToCheck[] = $r["main_channel_id"];
            if (!empty($r["conditional_channel_id"])) $channelsToCheck[] = $r["conditional_channel_id"];
            if (!empty($r["conditional_channel_2_id"])) $channelsToCheck[] = $r["conditional_channel_2_id"];
            if (!empty($r["conditional_channel_3_id"])) $channelsToCheck[] = $r["conditional_channel_3_id"];
            if (!empty($r["conditional_channel_4_id"])) $channelsToCheck[] = $r["conditional_channel_4_id"];
            if (!empty($r["conditional_channel_5_id"])) $channelsToCheck[] = $r["conditional_channel_5_id"];
            if (!empty($r["boost_channel_id"])) $channelsToCheck[] = $r["boost_channel_id"];
            
            foreach ($channelsToCheck as $channelId) {
                $member = apiRequest("getChatMember", [
                    "chat_id" => $channelId,
                    "user_id" => $userId
                ]);
                if ($member && $member["ok"] && isset($member["result"]["user"]) && is_array($member["result"]["user"]) && $checkPremium($member["result"]["user"])) {
                    $isPremium = true;
                    break;
                }
            }
        }
        
        // التحقق من أن Premium مفعل
        if (!$isPremium) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ يجب أن يكون حسابك مفعل بريميوم (Premium) للمشاركة.",
                "show_alert" => true
            ]);
            return;
        }
    }
    
    // فحص شرط يوزر NFT
    if (!empty($r["require_nft_username"])) {
        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
        if (!$userInfo || !$userInfo["ok"]) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ خطأ في التحقق من بياناتك.",
                "show_alert" => true
            ]);
            return;
        }
        $username = $userInfo["result"]["username"] ?? "";
        // التحقق من وجود يوزر NFT (يمكن تخصيص هذا الشرط حسب المنصة)
        if (empty($username)) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ يجب أن تمتلك يوزر منصة NFT للمشاركة.",
                "show_alert" => true
            ]);
            return;
        }
    }
    
    // فحص شرط اليوزر الثلاثي
    if (!empty($r["require_tripartite_username"])) {
        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
        if (!$userInfo || !$userInfo["ok"]) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ خطأ في التحقق من بياناتك.",
                "show_alert" => true
            ]);
            return;
        }
        $username = $userInfo["result"]["username"] ?? "";
        // التحقق من صيغة اليوزر الثلاثي - يجب أن يكون 3 أحرف فقط (مثال: A_U_D)
        if (empty($username) || !preg_match("/^[a-zA-Z0-9]_[a-zA-Z0-9]_[a-zA-Z0-9]$/", $username)) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ يجب أن يكون يوزرك بصيغة ثلاثية بالضبط (مثال: @A_U_D).",
                "show_alert" => true
            ]);
            return;
        }
    }
    
    // فحص شرط اليوزر المتغير
    if (!empty($r["variable_username_pattern"])) {
        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
        if (!$userInfo || !$userInfo["ok"]) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ خطأ في التحقق من بياناتك.",
                "show_alert" => true
            ]);
            return;
        }
        $username = $userInfo["result"]["username"] ?? "";
        $pattern = $r["variable_username_pattern"];
        
        if (empty($username)) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ يجب أن يكون يوزرك يطابق النمط المطلوب.",
                "show_alert" => true
            ]);
            return;
        }
        
        // تحويل النمط إلى regex (استبدال @متغير بأي حروف وأرقام)
        $patternRegex = preg_replace("/@متغير/", "[a-zA-Z0-9_]+", $pattern);
        // إزالة @ من البداية إذا كانت موجودة
        $patternRegex = ltrim($patternRegex, "@");
        // تحويل إلى regex pattern
        $patternRegex = "/^" . str_replace("/", "\\/", preg_quote($patternRegex, "/")) . "$/";
        // استبدال الـ quote من [a-zA-Z0-9_]+
        $patternRegex = str_replace("\\[a-zA-Z0-9_\\]\\+", "[a-zA-Z0-9_]+", $patternRegex);
        
        if (!preg_match($patternRegex, $username)) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ يجب أن يكون يوزرك يطابق النمط المطلوب.",
                "show_alert" => true
            ]);
            return;
        }
    }
    if (in_array($userId, $r["participants"])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["already_joined"],
            "show_alert" => true
        ]);
        return;
    }
    
    $roulettes[$rouletteId]["participants"][] = $userId;
    
    if (!saveData(ROULETTES_FILE, $roulettes)) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    updateRouletteMessage($rouletteId);
    
    $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
    if ($userInfo && $userInfo["ok"]) {
        $userDisplayName = getUserDisplayName($userInfo["result"]);
        $participantsCount = count($roulettes[$rouletteId]["participants"]);
        
        apiRequest("sendMessage", [
            "chat_id" => $r["creator_id"],
            "text" => sprintf($texts["new_participant"], $userDisplayName, $userId, $participantsCount)
        ]);
    }
    
    apiRequest("answerCallbackQuery", [
        "callback_query_id" => $callback["id"],
        "text" => $texts["joined"]
    ]);
}

function handleVerificationEmoji($userId, $callback, $emoji, $roulettes, $bannedUsers) {
    global $texts;
    
    $userStates = readData(USERS_FILE);
    $targetEmoji = $userStates[$userId]["verification_target"] ?? null;
    $rouletteId = $userStates[$userId]["verification_roulette_id"] ?? null;
    
    // التحقق من أن المستخدم في حالة انتظار التحقق
    if ($targetEmoji === null || $rouletteId === null) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "❗ لم يتم العثور على معلومات التحقق."
        ]);
        return;
    }
    
    // تنظيف حالة المستخدم
    unset($userStates[$userId]["state"]);
    unset($userStates[$userId]["verification_code"]);
    unset($userStates[$userId]["verification_target"]);
    unset($userStates[$userId]["verification_roulette_id"]);
    saveData(USERS_FILE, $userStates);
    
    // التحقق من الإجابة
    if ($emoji == $targetEmoji) {
        // التحقق صحيح - إضافة المستخدم
        if (!isset($roulettes[$rouletteId])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => "❗ هذا السحب لم يعد موجوداً.",
                "show_alert" => true
            ]);
            return;
        }
        
        $r = $roulettes[$rouletteId];
        
        // التحقق من حالة المشاركة (active)
        if (!$r["active"]) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["stopped"],
                "show_alert" => true
            ]);
            return;
        }
        
        // التحقق من القنوات/الكروبات الشرطية مرة أخرى
        if (!empty($r["conditional_channel_id"])) {
            $member = apiRequest("getChatMember", [
                "chat_id" => $r["conditional_channel_id"],
                "user_id" => $userId
            ]);
            if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => $texts["subscribe_first"],
                    "show_alert" => true
                ]);
                return;
            }
        }
        
        if (!empty($r["conditional_group_id"])) {
            $member = apiRequest("getChatMember", [
                "chat_id" => $r["conditional_group_id"],
                "user_id" => $userId
            ]);
            if (!$member || !$member["ok"] || in_array($member["result"]["status"], ["left", "kicked"])) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => $texts["subscribe_first"],
                    "show_alert" => true
                ]);
                return;
            }
        }
        
        // فحص شرط تعزيز القناة
        if (!empty($r["boost_channel_id"])) {
            $member = apiRequest("getChatMember", [
                "chat_id" => $r["boost_channel_id"],
                "user_id" => $userId
            ]);
            if (!$member || !$member["ok"]) {
                $boostLink = !empty($r['boost_channel_link']) ? $r['boost_channel_link'] : 'https://t.me/boost/' . ltrim($r['boost_channel_username'], '@');
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب الاشتراك وتعزيز القناة أولاً للمشاركة.\n\n🚀 اضغط على رابط التعزيز في الرسالة.",
                    "show_alert" => true
                ]);
                return;
            }
            $status = $member["result"]["status"] ?? "";
            if (in_array($status, ["left", "kicked"])) {
                $boostLink = !empty($r['boost_channel_link']) ? $r['boost_channel_link'] : 'https://t.me/boost/' . ltrim($r['boost_channel_username'], '@');
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب الاشتراك وتعزيز القناة أولاً للمشاركة.\n\n🚀 اضغط على رابط التعزيز في الرسالة.",
                    "show_alert" => true
                ]);
                return;
            }
            // التحقق من أن المستخدم ليس عضو عادي فقط (يجب أن يكون قد عزز)
            if ($status === "member") {
                $boostLink = !empty($r['boost_channel_link']) ? $r['boost_channel_link'] : 'https://t.me/boost/' . ltrim($r['boost_channel_username'] ?? '', '@');
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب تعزيز القناة أولاً للمشاركة.\n\n🚀 اضغط على رابط التعزيز: " . $boostLink,
                    "show_alert" => true
                ]);
                return;
            }
        }
        
        // فحص شرط الحساب المميز
        if (!empty($r["require_premium"])) {
            $isPremium = false;
            
            // دالة مساعدة للتحقق من Premium من أي مصدر - أكثر مرونة
            $checkPremium = function($userData) {
                if (!is_array($userData) || !array_key_exists("is_premium", $userData)) {
                    return false;
                }
                $value = $userData["is_premium"];
                // التحقق من جميع الأشكال الممكنة: true, 1, "true", "1", أو أي قيمة truthy
                if ($value === true || $value === 1 || $value === "true" || $value === "1") {
                    return true;
                }
                // التحقق من القيم truthy الأخرى (لكن بحذر)
                if ($value && $value !== false && $value !== 0 && $value !== "false" && $value !== "0") {
                    return true;
                }
                return false;
            };
            
            $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
            if ($userInfo && $userInfo["ok"] && isset($userInfo["result"]) && is_array($userInfo["result"])) {
                if ($checkPremium($userInfo["result"])) {
                    $isPremium = true;
                }
            }
            
            // محاولة أخرى باستخدام getChatMember من أي قناة متاحة
            if (!$isPremium) {
                $channelsToCheck = [];
                if (!empty($r["main_channel_id"])) $channelsToCheck[] = $r["main_channel_id"];
                if (!empty($r["conditional_channel_id"])) $channelsToCheck[] = $r["conditional_channel_id"];
                if (!empty($r["boost_channel_id"])) $channelsToCheck[] = $r["boost_channel_id"];
                
                foreach ($channelsToCheck as $channelId) {
                    $member = apiRequest("getChatMember", [
                        "chat_id" => $channelId,
                        "user_id" => $userId
                    ]);
                    if ($member && $member["ok"] && isset($member["result"]["user"]) && is_array($member["result"]["user"]) && $checkPremium($member["result"]["user"])) {
                        $isPremium = true;
                        break;
                    }
                }
            }
            
            if (!$isPremium) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب أن يكون حسابك مفعل بريميوم (Premium) للمشاركة.",
                    "show_alert" => true
                ]);
                return;
            }
        }
        
        // فحص شرط يوزر NFT
        if (!empty($r["require_nft_username"])) {
            $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
            if (!$userInfo || !$userInfo["ok"]) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ خطأ في التحقق من بياناتك.",
                    "show_alert" => true
                ]);
                return;
            }
            $username = $userInfo["result"]["username"] ?? "";
            if (empty($username)) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب أن تمتلك يوزر منصة NFT للمشاركة.",
                    "show_alert" => true
                ]);
                return;
            }
        }
        
        // فحص شرط اليوزر الثلاثي
        if (!empty($r["require_tripartite_username"])) {
            $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
            if (!$userInfo || !$userInfo["ok"]) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ خطأ في التحقق من بياناتك.",
                    "show_alert" => true
                ]);
                return;
            }
            $username = $userInfo["result"]["username"] ?? "";
            // التحقق من صيغة اليوزر الثلاثي - يجب أن يكون 3 أحرف فقط (مثال: A_U_D)
            if (empty($username) || !preg_match("/^[a-zA-Z0-9]_[a-zA-Z0-9]_[a-zA-Z0-9]$/", $username)) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب أن يكون يوزرك بصيغة ثلاثية بالضبط (مثال: @A_U_D).",
                    "show_alert" => true
                ]);
                return;
            }
        }
        
        // فحص شرط اليوزر المتغير
        if (!empty($r["variable_username_pattern"])) {
            $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
            if (!$userInfo || !$userInfo["ok"]) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ خطأ في التحقق من بياناتك.",
                    "show_alert" => true
                ]);
                return;
            }
            $username = $userInfo["result"]["username"] ?? "";
            $pattern = $r["variable_username_pattern"];
            
            if (empty($username)) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب أن يكون يوزرك يطابق النمط المطلوب.",
                    "show_alert" => true
                ]);
                return;
            }
            
            // تحويل النمط إلى regex (استبدال @متغير بأي حروف وأرقام)
            $patternRegex = preg_replace("/@متغير/", "[a-zA-Z0-9_]+", $pattern);
            // إزالة @ من البداية إذا كانت موجودة
            $patternRegex = ltrim($patternRegex, "@");
            // تحويل إلى regex pattern
            $patternRegex = "/^" . str_replace("/", "\\/", preg_quote($patternRegex, "/")) . "$/";
            // استبدال الـ quote من [a-zA-Z0-9_]+
            $patternRegex = str_replace("\\[a-zA-Z0-9_\\]\\+", "[a-zA-Z0-9_]+", $patternRegex);
            
            if (!preg_match($patternRegex, $username)) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callback["id"],
                    "text" => "❗ يجب أن يكون يوزرك يطابق النمط المطلوب.",
                    "show_alert" => true
                ]);
                return;
            }
        }
        
        if (in_array($userId, $r["participants"])) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["already_joined"],
                "show_alert" => true
            ]);
            return;
        }
        
        $roulettes[$rouletteId]["participants"][] = $userId;
        
        if (!saveData(ROULETTES_FILE, $roulettes)) {
            apiRequest("answerCallbackQuery", [
                "callback_query_id" => $callback["id"],
                "text" => $texts["file_error"],
                "show_alert" => true
            ]);
            return;
        }
        
        updateRouletteMessage($rouletteId);
        
        $userInfo = apiRequest("getChat", ["chat_id" => $userId]);
        if ($userInfo && $userInfo["ok"]) {
            $userDisplayName = getUserDisplayName($userInfo["result"]);
            $participantsCount = count($roulettes[$rouletteId]["participants"]);
            
            apiRequest("sendMessage", [
                "chat_id" => $r["creator_id"],
                "text" => sprintf($texts["new_participant"], $userDisplayName, $userId, $participantsCount)
            ]);
        }
        
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["verification_success"],
            "show_alert" => true
        ]);
    } else {
        // الإجابة خاطئة
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["verification_failed"],
            "show_alert" => true
        ]);
    }
}

function handleToggleParticipation($userId, $callback, $rouletteId, $roulettes) {
    global $texts;
    
    if (!isset($roulettes[$rouletteId])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "❗ هذا السحب لم يعد موجوداً."
        ]);
        return;
    }
    
    $r = $roulettes[$rouletteId];
    
    if ($userId != $r["creator_id"] && $userId != BOT_OWNER_ID) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["not_your_command"]
        ]);
        return;
    }
    
    // تبديل الحالة
    $roulettes[$rouletteId]["active"] = !$r["active"];
    
    if (!saveData(ROULETTES_FILE, $roulettes)) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    // تحديث الرسالة في القناة
    $success = updateRouletteMessage($rouletteId);
    
    if (!$success) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "⚠️ تم التبديل لكن فشل تحديث الرسالة في القناة"
        ]);
        return;
    }
    
    $statusText = $roulettes[$rouletteId]["active"] ? $texts["participation_on"] : $texts["participation_off"];
    apiRequest("answerCallbackQuery", [
        "callback_query_id" => $callback["id"],
        "text" => $statusText,
        "show_alert" => true
    ]);
}

function handleStartDraw($userId, $callback, $rouletteId, $roulettes) {
    global $texts;

    if (!isset($roulettes[$rouletteId])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "❗ هذا السحب لم يعد موجوداً."
        ]);
        return;
    }

    $r = $roulettes[$rouletteId];

    if ($userId != $r["creator_id"] && $userId != BOT_OWNER_ID) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["not_your_command"]
        ]);
        return;
    }

    // التحقق من أن المشاركة متوقفة قبل السماح بالسحب
    if ($r["active"]) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "❗ يجب إيقاف المشاركة أولاً قبل السحب.\n\n⏸️ اضغط زر 'إيقاف المشاركة' ثم حاول السحب مرة أخرى.",
            "show_alert" => true
        ]);
        return;
    }

    if (empty($r["participants"])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["no_participants"]
        ]);
        return;
    }
    $alreadyWinners = $r["winners"] ?? [];
    $potential = array_values(array_diff($r["participants"], $alreadyWinners));
    if (count($potential) === 0) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "تم الانتهاء من السحب، جميع المشاركين فازوا!"
        ]);
        return;
    }
    $winners_left = $r['winners_count'];
    $drawHowMany = min(count($potential), $winners_left);
    // سحب دفعة واحدة بعدد winners_count أو جميع المتبقين
    if ($drawHowMany === 1) {
        $drawArr = [$potential[array_rand($potential)]];
    } else {
        $drawArr = array_rand(array_flip($potential), $drawHowMany);
        if (!is_array($drawArr)) {
            $drawArr = [$drawArr];
        }
    }
    // أضف هؤلاء الفائزين الجدد للسجل
    if (!isset($roulettes[$rouletteId]["winners"])) $roulettes[$rouletteId]["winners"] = [];
    foreach ($drawArr as $winnerId) {
        if (!in_array($winnerId, $roulettes[$rouletteId]["winners"])) {
            $roulettes[$rouletteId]["winners"][] = $winnerId;
        }
    }
    saveData(ROULETTES_FILE, $roulettes);
    updateRouletteMessage($rouletteId);

    $mainChannelId = $r["main_channel_id"];
    // طباعة الكليشة
    $winnersMsg = "الفائزين في الروليت هم:\n";
    $idx = 1;
    foreach ($drawArr as $winId) {
        $userInfo = apiRequest("getChat", ["chat_id" => $winId]);
        $displayName = ($userInfo && $userInfo["ok"]) ? getUserDisplayName($userInfo["result"]) : ("المستخدم $winId");
        $tg_link = "tg://user?id=$winId";
        $winnersMsg .= "\n$idx- <a href=\"$tg_link\">$displayName</a>";
        $idx++;
    }
    // إضافة رابط البوت في نهاية النص
    $botUsername = getBotUsername();
    $botLink = "tg://resolve?domain=" . $botUsername;
    $winnersMsg .= "\n\n<a href=\"" . $botLink . "\">روليت رادار</a>";

    apiRequest("sendMessage", [
        "chat_id" => $mainChannelId,
        "text" => $winnersMsg,
        "parse_mode" => "HTML"
    ]);

    // إرسال إشعار خاص للفائزين الجدد الذين فعّلوا التذكير فقط
    foreach ($drawArr as $winnerId) {
        if (in_array($winnerId, $r["reminders"])) {
            apiRequest("sendMessage", [
                "chat_id" => $winnerId,
                "text" => "🎉 تهانينا! لقد فزت في السحب في هذه القناة: " . $r["main_channel_username"]
            ]);
        }
    }
    apiRequest("answerCallbackQuery", [
        "callback_query_id" => $callback["id"],
        "text" => "تم السحب لجميع الفائزين الجدد!"
    ]);
}

function handleViewParticipants($userId, $callback, $rouletteId, $roulettes) {
    global $texts;
    
    if (!isset($roulettes[$rouletteId])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "❗ هذا السحب لم يعد موجوداً."
        ]);
        return;
    }
    
    $r = $roulettes[$rouletteId];
    
    if ($userId != $r["creator_id"] && $userId != BOT_OWNER_ID) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["not_your_command"]
        ]);
        return;
    }
    
    if (empty($r["participants"])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["no_participants_list"]
        ]);
        return;
    }
    
    $participantsList = "";
    $counter = 1;
    
    foreach ($r["participants"] as $participantId) {
        $userInfo = apiRequest("getChat", ["chat_id" => $participantId]);
        if ($userInfo && $userInfo["ok"]) {
            $participantsList .= $counter . ". " . getUserDisplayName($userInfo["result"]) . " (ID: " . $participantId . ")\n";
        } else {
            $participantsList .= $counter . ". المستخدم " . $participantId . "\n";
        }
        $counter++;
    }
    
    $messageText = sprintf($texts["participants_list"], $participantsList);
    
    apiRequest("sendMessage", [
        "chat_id" => $userId,
        "text" => $messageText
    ]);
}

function handleExcludeParticipant($userId, $callback, $rouletteId, $participantId, $roulettes, $bannedUsers) {
    global $texts;
    
    if (!isset($roulettes[$rouletteId])) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => "❗ هذا السحب لم يعد موجوداً."
        ]);
        return;
    }
    
    $r = $roulettes[$rouletteId];
    
    if ($userId != $r["creator_id"] && $userId != BOT_OWNER_ID) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["not_your_command"]
        ]);
        return;
    }
    
    $participantIndex = array_search($participantId, $r["participants"]);
    if ($participantIndex === false) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["not_in_roulette"]
        ]);
        return;
    }
    
    unset($roulettes[$rouletteId]["participants"][$participantIndex]);
    $roulettes[$rouletteId]["participants"] = array_values($roulettes[$rouletteId]["participants"]);
    
    if (!isset($bannedUsers[$userId])) {
        $bannedUsers[$userId] = [];
    }
    
    if (!in_array($participantId, $bannedUsers[$userId])) {
        $bannedUsers[$userId][] = $participantId;
    }
    
    if (!saveData(ROULETTES_FILE, $roulettes) || !saveData(BANNED_USERS_FILE, $bannedUsers)) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callback["id"],
            "text" => $texts["file_error"]
        ]);
        return;
    }
    
    updateRouletteMessage($rouletteId);
    
    apiRequest("answerCallbackQuery", [
        "callback_query_id" => $callback["id"],
        "text" => $texts["participant_excluded"]
    ]);
}

function handleRemindMeGlobalInfo($userId, $chatId, $messageId) {
    global $texts;
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["reminder_info"],
        "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
    ]);
}

// دوال لوحة التحكم
function handleRemoveAdminById($userId, $chatId, $adminId) {
    global $texts;
    
    if (!isOwner($userId)) {
        return;
    }
    
    if (removeAdmin($adminId)) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $GLOBALS["callback_id"] ?? "",
            "text" => $texts["admin_removed"]
        ]);
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["admin_removed"],
            "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
        ]);
    }
}

function handleAdminPanel($userId, $chatId, $messageId) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $texts["admin_panel"],
        "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
    ]);
}

function handleAdminStats($userId, $chatId, $messageId) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $userCount = getUserCount();
    $roulettes = readJsonFile(ROULETTES_FILE);
    $rouletteCount = count($roulettes);
    
    // حساب الإحصائيات التفصيلية
    $totalParticipants = 0;
    $totalWinners = 0;
    $completedDraws = 0;
    $activeRoulettes = 0;
    $inactiveRoulettes = 0;
    $totalChannels = 0;
    
    foreach ($roulettes as $roulette) {
        // عدد المشاركين
        if (isset($roulette["participants"]) && is_array($roulette["participants"])) {
            $totalParticipants += count($roulette["participants"]);
        }
        
        // عدد الفائزين
        if (isset($roulette["winners"]) && is_array($roulette["winners"])) {
            $winnerCount = count($roulette["winners"]);
            $totalWinners += $winnerCount;
            if ($winnerCount > 0) {
                $completedDraws++;
            }
        }
        
        // الروليتات النشطة/غير النشطة
        if (isset($roulette["active"]) && $roulette["active"]) {
            $activeRoulettes++;
        } else {
            $inactiveRoulettes++;
        }
    }
    
    // حساب عدد القنوات الفريدة
    $uniqueChannels = [];
    foreach ($roulettes as $roulette) {
        if (isset($roulette["main_channel_id"])) {
            $uniqueChannels[$roulette["main_channel_id"]] = true;
        }
    }
    $totalChannels = count($uniqueChannels);
    
    // متوسط المشاركين لكل روليت
    $avgParticipants = $rouletteCount > 0 ? round($totalParticipants / $rouletteCount, 2) : 0;
    
    // بناء رسالة الإحصائيات
    $stats = "📊 إحصائيات البوت الشاملة\n\n";
    $stats .= "👥 عدد المستخدمين: " . $userCount . "\n";
    $stats .= "🎯 عدد الروليتات: " . $rouletteCount . "\n";
    $stats .= "   ├─ ✅ نشطة: " . $activeRoulettes . "\n";
    $stats .= "   └─ ⛔ متوقفة: " . $inactiveRoulettes . "\n\n";
    
    $stats .= "📈 إحصائيات المشاركين والفائزين:\n";
    $stats .= "👥 إجمالي المشاركين: " . $totalParticipants . "\n";
    $stats .= "🏆 إجمالي الفائزين: " . $totalWinners . "\n";
    $stats .= "📊 متوسط المشاركين/روليت: " . $avgParticipants . "\n\n";
    
    $stats .= "🎲 إحصائيات السحوبات:\n";
    $stats .= "✅ عدد السحوبات المكتملة: " . $completedDraws . "\n";
    $stats .= "⏳ عدد السحوبات قيد الانتظار: " . ($rouletteCount - $completedDraws) . "\n\n";
    
    $stats .= "📺 عدد القنوات/المجموعات المستخدمة: " . $totalChannels;
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $stats,
        "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
    ]);
}

function handleAdminAdd($userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isOwner($userId)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["owner_only"]
        ]);
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_admin_id";
    $userStates[$userId]["action"] = "add_admin";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => "📝 أرسل معرف المستخدم (User ID) الذي تريد إضافته كأدمن:"
    ]);
}

function handleAdminRemove($userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isOwner($userId)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["owner_only"]
        ]);
        return;
    }
    
    $admins = getAdmins();
    if (empty($admins)) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ لا يوجد أدمن حالياً."
        ]);
        return;
    }
    
    $keyboard = [];
    foreach ($admins as $adminId) {
        $userInfo = apiRequest("getChat", ["chat_id" => $adminId]);
        $displayName = $userInfo && $userInfo["ok"] ? getUserDisplayName($userInfo["result"]) : "المستخدم " . $adminId;
        $keyboard[] = [["text" => "🗑️ " . $displayName, "callback" => "remove_admin_" . $adminId]];
    }
    $keyboard[] = [["text" => "🔙 رجوع", "callback" => "admin_panel"]];
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => "اختر الأدمن الذي تريد حذفه:",
        "reply_markup" => buildKeyboard($keyboard, true)
    ]);
}

function handleAdminIdInput($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    if (!isOwner($userId)) {
        return;
    }
    
    $targetUserId = intval(trim($text));
    
    if ($targetUserId <= 0) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["user_not_found"]
        ]);
        return;
    }
    
    $action = $userStates[$userId]["action"] ?? "";
    unset($userStates[$userId]["state"]);
    unset($userStates[$userId]["action"]);
    saveData(USERS_FILE, $userStates);
    
    if ($action == "add_admin") {
        if (addAdmin($targetUserId)) {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["admin_added"]
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "⚠️ المستخدم أدمن مسبقاً أو حدث خطأ."
            ]);
        }
    }
}

function handleAdminNotifyOn($userId, $chatId, $messageId) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    updateBotSettings(["notifications_enabled" => true]);
    
    $callbackId = $GLOBALS["callback_id"] ?? "";
    if ($callbackId) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callbackId,
            "text" => $texts["notifications_enabled"]
        ]);
    }
    
    handleAdminPanel($userId, $chatId, $messageId);
}

function handleAdminNotifyOff($userId, $chatId, $messageId) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    updateBotSettings(["notifications_enabled" => false]);
    
    $callbackId = $GLOBALS["callback_id"] ?? "";
    if ($callbackId) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callbackId,
            "text" => $texts["notifications_disabled"]
        ]);
    }
    
    handleAdminPanel($userId, $chatId, $messageId);
}

function handleAdminMandatoryChannels($userId, $chatId, $messageId) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $channels = getMandatoryChannels();
    $keyboard = [
        [["text" => "➕ إضافة قناة عامة", "callback" => "add_mandatory_channel_public"]],
        [["text" => "➕ إضافة قناة خاصة", "callback" => "add_mandatory_channel_private"]]
    ];
    
    if (!empty($channels)) {
        foreach ($channels as $channelId => $channelInfo) {
            $displayName = "@" . ltrim($channelInfo["username"], "@") . " (" . ($channelInfo["type"] == "public" ? "عامة" : "خاصة") . ")";
            $keyboard[] = [["text" => "🗑️ " . $displayName, "callback" => "remove_mandatory_channel_" . $channelId]];
        }
    }
    
    $keyboard[] = [["text" => "🔙 رجوع", "callback" => "admin_panel"]];
    
    $text = "📛 إدارة القنوات الإجبارية\n\n";
    if (empty($channels)) {
        $text .= "لا توجد قنوات إجبارية حالياً.";
    } else {
        $text .= "القنوات الإجبارية الحالية:\n";
        foreach ($channels as $channelInfo) {
            if ($channelInfo["type"] == "private" && !empty($channelInfo["invite_link"])) {
                $text .= "🔒 قناة/مجموعة خاصة (" . ($channelInfo["invite_link"] ? "رابط: " . substr($channelInfo["invite_link"], 0, 30) . "..." : "بدون رابط") . ")\n";
            } else {
                $username = !empty($channelInfo["username"]) ? "@" . ltrim($channelInfo["username"], "@") : "غير معروف";
                $text .= "📢 " . $username . " (" . ($channelInfo["type"] == "public" ? "عامة" : "خاصة") . ")\n";
            }
        }
    }
    
    apiRequest("editMessageText", [
        "chat_id" => $chatId,
        "message_id" => $messageId,
        "text" => $text,
        "reply_markup" => buildKeyboard($keyboard, true)
    ]);
}

function handleAddMandatoryChannelPrompt($userId, $chatId, &$userStates, $channelType) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_mandatory_channel";
    $userStates[$userId]["channel_type"] = $channelType;
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => "📝 أرسل رابط القناة (مثال: @channel_name أو https://t.me/channel_name):"
    ]);
}

function handleMandatoryChannelInput($message, $userId, $chatId, &$userStates, $text) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $channelType = $userStates[$userId]["channel_type"] ?? "public";
    unset($userStates[$userId]["state"]);
    unset($userStates[$userId]["channel_type"]);
    saveData(USERS_FILE, $userStates);
    
    $channelLink = trim($text);
    $channelId = null;
    $channelUsername = null;
    $inviteLink = null;
    
    // التحقق من رابط الدعوة (للقنوات الخاصة)
    if (preg_match("/(?:https?:\/\/)?(?:t\.me\/|telegram\.me\/)(joinchat\/[a-zA-Z0-9_-]+|\+[a-zA-Z0-9_-]+)/i", $channelLink, $inviteMatches)) {
        // قناة/مجموعة خاصة برابط دعوة
        $inviteLink = $channelLink;
        if (!preg_match("/^https?:\/\//", $inviteLink)) {
            $inviteLink = "https://t.me/" . ltrim($inviteLink, "t.me/");
        }
        
        // للقنوات الخاصة برابط دعوة، نطلب من المستخدم إعادة توجيه رسالة للحصول على channelId
        $userStates[$userId]["state"] = "awaiting_private_channel_forward";
        $userStates[$userId]["invite_link"] = $inviteLink;
        saveData(USERS_FILE, $userStates);
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "🔗 تم حفظ رابط الدعوة: " . $inviteLink . "\n\n📌 للتحقق من الاشتراك بشكل صحيح، نحتاج معرف القناة الحقيقي.\n\n⚠️ يرجى:\n1️⃣ إعادة توجيه رسالة من القناة/المجموعة الخاصة\nأو\n2️⃣ أرسل /cancel للإلغاء"
        ]);
        return;
    }
    
    // التحقق من قناة عامة
    if (preg_match("/^(?:https?:\/\/t\.me\/)?@?([a-zA-Z0-9_]+)$/", $channelLink, $matches)) {
        $channelUsername = "@".$matches[1];
        
        $response = apiRequest("getChat", ["chat_id" => $channelUsername]);
        if ($response && $response["ok"] && ($response["result"]["type"] == "channel" || $response["result"]["type"] == "group")) {
            $channelId = $response["result"]["id"];
            $channelUsername = $response["result"]["username"] ?? $channelUsername;
            
            // التحقق من أن البوت مشرف في القناة
            $botId = explode(":", BOT_TOKEN)[0];
            $adminCheck = apiRequest("getChatMember", [
                "chat_id" => $channelId,
                "user_id" => $botId
            ]);
            
            if (!$adminCheck || !$adminCheck["ok"] || !in_array($adminCheck["result"]["status"], ["administrator", "creator"])) {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => "❗ البوت ليس مشرفاً في هذه القناة.\n\n⚠️ يرجى:\n1️⃣ إضافة البوت كمشرف في القناة: @".ltrim($channelUsername, "@")."\n2️⃣ ثم أعد المحاولة لإضافة القناة الإجبارية."
                ]);
                return;
            }
            
            // محاولة الحصول على رابط الدعوة للقنوات العامة أيضاً
            try {
                $exportResponse = apiRequest("exportChatInviteLink", ["chat_id" => $channelId]);
                if ($exportResponse && $exportResponse["ok"]) {
                    $inviteLink = $exportResponse["result"]["invite_link"];
                }
            } catch (Exception $e) {
                // تجاهل الخطأ
            }
            
            // إذا لم نحصل على رابط الدعوة، نحاول إنشاء رابط عام
            if (empty($inviteLink)) {
                $inviteLink = "https://t.me/".ltrim($channelUsername, "@");
            }
            
            if (addMandatoryChannel($channelId, $channelUsername, $channelType, $inviteLink)) {
                $message = sprintf($texts["channel_added_mandatory"], $channelUsername);
                if (!empty($inviteLink)) {
                    $message .= "\n\n🔗 رابط القناة الإجبارية:\n".$inviteLink;
                }
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $message
                ]);
            } else {
                apiRequest("sendMessage", [
                    "chat_id" => $chatId,
                    "text" => $texts["channel_already_mandatory"]
                ]);
            }
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_found"]
            ]);
        }
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["invalid_link"]
        ]);
    }
}

function handleRemoveMandatoryChannel($userId, $chatId, $messageId, $channelId) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $channels = getMandatoryChannels();
    if (isset($channels[$channelId])) {
        $channelUsername = $channels[$channelId]["username"];
        if (removeMandatoryChannel($channelId)) {
            $callbackId = $GLOBALS["callback_id"] ?? "";
            if ($callbackId) {
                apiRequest("answerCallbackQuery", [
                    "callback_query_id" => $callbackId,
                    "text" => sprintf($texts["channel_removed_mandatory"], $channelUsername)
                ]);
            }
            handleAdminMandatoryChannels($userId, $chatId, $messageId);
        }
    }
}

function handleAdminKickAll($userId, $chatId, $messageId) {
    global $texts;
    
    if (!isOwner($userId)) {
        return;
    }
    
    // إرسال رسالة تأكيد
    $callbackId = $GLOBALS["callback_id"] ?? "";
    if ($callbackId) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callbackId,
            "text" => "جاري حذف جميع المستخدمين..."
        ]);
    }
    
    $kicked = kickAllUsers();
    
    $message = sprintf($texts["all_users_kicked"] . "\n\n✅ تم حذف %d مستخدم\n👤 تم الاحتفاظ بالمالك والأدمن فقط", $kicked);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $message,
        "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
    ]);
}

function handleAdminLeaveAll($userId, $chatId, $messageId) {
    global $texts;
    
    if (!isOwner($userId)) {
        return;
    }
    
    // إرسال رسالة تأكيد
    $callbackId = $GLOBALS["callback_id"] ?? "";
    if ($callbackId) {
        apiRequest("answerCallbackQuery", [
            "callback_query_id" => $callbackId,
            "text" => "جاري الخروج من جميع القنوات والمجموعات..."
        ]);
    }
    
    $result = leaveAllChats();
    $left = $result["left"];
    $failed = $result["failed"];
    
    $message = sprintf($texts["bot_left_all"] . "\n\n✅ تم الخروج من %d قناة/مجموعة", $left);
    if ($failed > 0) {
        $message .= "\n⚠️ فشل الخروج من " . $failed . " قناة/مجموعة (قد لا يكون البوت موجوداً فيها)";
    }
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $message,
        "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
    ]);
}

function handleAdminSendToAllUsers($userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_message_to_users";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["enter_message_to_send"]
    ]);
}

function handleAdminSendToAllChats($userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $userStates[$userId]["state"] = "awaiting_message_to_chats";
    saveData(USERS_FILE, $userStates);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $texts["enter_message_to_send"]
    ]);
}

function handleMessageToUsers($message, $userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $users = readJsonFile(USERS_FILE);
    $admins = getAdmins();
    $sent = 0;
    $failed = 0;
    
    // إعداد الرسالة
    $text = $message["text"] ?? "";
    $photo = isset($message["photo"]) ? $message["photo"] : null;
    $caption = $message["caption"] ?? "";
    
    // استخدام caption إذا كان موجوداً مع الصورة
    if ($photo && !empty($caption)) {
        $text = $caption;
    }
    
    // إرسال الرسالة لكل مستخدم
    foreach ($users as $targetUserId => $userData) {
        // تخطي المالك والأدمن
        if ($targetUserId == BOT_OWNER_ID || in_array($targetUserId, $admins)) {
            continue;
        }
        
        try {
            if ($photo) {
                // إرسال صورة
                $photoFileId = end($photo)["file_id"];
                $params = [
                    "chat_id" => $targetUserId,
                    "photo" => $photoFileId
                ];
                
                if (!empty($text)) {
                    $params["caption"] = $text;
                }
                
                $response = apiRequest("sendPhoto", $params);
            } else if (!empty($text)) {
                // إرسال نص فقط
                $response = apiRequest("sendMessage", [
                    "chat_id" => $targetUserId,
                    "text" => $text
                ]);
            } else {
                continue; // لا يوجد نص ولا صورة
            }
            
            if ($response && isset($response["ok"]) && $response["ok"]) {
                $sent++;
            } else {
                $failed++;
            }
            
            // تأخير بسيط لتجنب rate limiting
            usleep(50000); // 0.05 ثانية
        } catch (Exception $e) {
            $failed++;
        }
    }
    
    // تنظيف الحالة
    unset($userStates[$userId]["state"]);
    saveData(USERS_FILE, $userStates);
    
    // إرسال تقرير
    $report = sprintf($texts["message_sent_to_users"], $sent, $failed);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $report,
        "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
    ]);
}

function handleMessageToChats($message, $userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    $userChannels = readJsonFile(USER_CHANNELS_FILE);
    $sent = 0;
    $failed = 0;
    $processedChannels = [];
    
    // إعداد الرسالة
    $text = $message["text"] ?? "";
    $photo = isset($message["photo"]) ? $message["photo"] : null;
    $caption = $message["caption"] ?? "";
    
    // استخدام caption إذا كان موجوداً مع الصورة
    if ($photo && !empty($caption)) {
        $text = $caption;
    }
    
    // جمع جميع القنوات والمجموعات الفريدة
    foreach ($userChannels as $channelUserId => $channels) {
        foreach ($channels as $channelId => $channelInfo) {
            if (!in_array($channelId, $processedChannels)) {
                $processedChannels[] = $channelId;
                
                try {
                    // التحقق من أن channelId صالح (ليس hash)
                    if (strlen($channelId) == 32 && ctype_xdigit($channelId)) {
                        // هذا hash، تخطي
                        continue;
                    }
                    
                    // التحقق من نوع المحادثة قبل الإرسال (للمجموعات)
                    $chatInfo = apiRequest("getChat", ["chat_id" => $channelId]);
                    if (!$chatInfo || !$chatInfo["ok"]) {
                        $failed++;
                        continue;
                    }
                    
                    $chatType = $chatInfo["result"]["type"] ?? "";
                    // دعم القنوات والمجموعات (channel, group, supergroup)
                    if (!in_array($chatType, ["channel", "group", "supergroup"])) {
                        continue;
                    }
                    
                    if ($photo) {
                        // إرسال صورة
                        $photoFileId = end($photo)["file_id"];
                        $params = [
                            "chat_id" => $channelId,
                            "photo" => $photoFileId
                        ];
                        
                        if (!empty($text)) {
                            $params["caption"] = $text;
                        }
                        
                        $response = apiRequest("sendPhoto", $params);
                    } else if (!empty($text)) {
                        // إرسال نص فقط
                        $response = apiRequest("sendMessage", [
                            "chat_id" => $channelId,
                            "text" => $text
                        ]);
                    } else {
                        continue; // لا يوجد نص ولا صورة
                    }
                    
                    if ($response && isset($response["ok"]) && $response["ok"]) {
                        $sent++;
                    } else {
                        $failed++;
                        // تسجيل الخطأ للتصحيح
                        error_log("Failed to send to chat " . $channelId . ": " . json_encode($response));
                    }
                    
                    // تأخير بسيط لتجنب rate limiting
                    usleep(100000); // 0.1 ثانية
                } catch (Exception $e) {
                    $failed++;
                    error_log("Exception sending to chat " . $channelId . ": " . $e->getMessage());
                }
            }
        }
    }
    
    // إرسال للقنوات الإجبارية أيضاً
    $mandatoryChannels = getMandatoryChannels();
    foreach ($mandatoryChannels as $channelId => $channelInfo) {
        if (!in_array($channelId, $processedChannels)) {
            $processedChannels[] = $channelId;
            
            try {
                if ($photo) {
                    $photoFileId = end($photo)["file_id"];
                    $params = [
                        "chat_id" => $channelId,
                        "photo" => $photoFileId
                    ];
                    
                    if (!empty($text)) {
                        $params["caption"] = $text;
                    }
                    
                    $response = apiRequest("sendPhoto", $params);
                } else if (!empty($text)) {
                    $response = apiRequest("sendMessage", [
                        "chat_id" => $channelId,
                        "text" => $text
                    ]);
                } else {
                    continue;
                }
                
                if ($response && isset($response["ok"]) && $response["ok"]) {
                    $sent++;
                } else {
                    $failed++;
                }
                
                usleep(100000);
            } catch (Exception $e) {
                $failed++;
            }
        }
    }
    
    // تنظيف الحالة
    unset($userStates[$userId]["state"]);
    saveData(USERS_FILE, $userStates);
    
    // إرسال تقرير
    $report = sprintf($texts["message_sent_to_chats"], $sent, $failed);
    
    apiRequest("sendMessage", [
        "chat_id" => $chatId,
        "text" => $report,
        "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
    ]);
}

function handleCheckSubscription($userId, $chatId, $messageId) {
    global $texts;
    
    $subscriptionCheck = checkMandatorySubscription($userId);
    if ($subscriptionCheck["success"]) {
        // المستخدم مشترك في جميع القنوات، إرسال القائمة الرئيسية
        $userStates = readData(USERS_FILE);
        unset($userStates[$userId]["state"]);
        saveData(USERS_FILE, $userStates);
        
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => "✅ شكراً لك! يمكنك الآن استخدام البوت.",
            "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
        ]);
    } else {
        // لا يزال مفقود بعض القنوات
        $missingList = "";
        $buttons = [];
        foreach ($subscriptionCheck["missing"] as $channel) {
            // استخدام invite link إذا كان متوفراً (للقنوات الخاصة)
            if (!empty($channel["invite_link"])) {
                $channelLink = $channel["invite_link"];
                $displayName = ($channel["type"] == "private") ? "🔒 قناة/مجموعة خاصة" : "@" . ltrim($channel["username"], "@");
                $missingList .= "📢 " . $displayName . "\n";
                $buttons[] = [["text" => "✅ اشترك هنا", "url" => $channelLink]];
            } else if (!empty($channel["username"])) {
                // قناة عامة
                $channelLink = "https://t.me/" . ltrim($channel["username"], "@");
                $missingList .= "📢 @" . ltrim($channel["username"], "@") . "\n";
                $buttons[] = [["text" => "✅ اشترك @" . ltrim($channel["username"], "@"), "url" => $channelLink]];
            } else {
                // قناة خاصة بدون invite link
                $displayName = "🔒 قناة/مجموعة خاصة";
                $missingList .= "📢 " . $displayName . "\n";
            }
        }
        $buttons[] = [["text" => "✅ تحقق من الاشتراك", "callback" => "check_subscription"]];
        
        apiRequest("editMessageText", [
            "chat_id" => $chatId,
            "message_id" => $messageId,
            "text" => sprintf($texts["must_subscribe"], $missingList),
            "reply_markup" => buildKeyboard($buttons, true)
        ]);
    }
}

function handlePrivateChannelForward($message, $userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isAdmin($userId)) {
        return;
    }
    
    // التحقق من إعادة التوجيه
    if (!isset($message["forward_from_chat"])) {
        if (isset($message["text"]) && strpos($message["text"], "/cancel") === 0) {
            unset($userStates[$userId]["state"]);
            unset($userStates[$userId]["invite_link"]);
            saveData(USERS_FILE, $userStates);
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❌ تم الإلغاء.",
                "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
            ]);
            return;
        }
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⚠️ يرجى إعادة توجيه رسالة من القناة/المجموعة الخاصة.\n\nأو أرسل /cancel للإلغاء."
        ]);
        return;
    }
    
    $forwardChat = $message["forward_from_chat"];
    $chatType = $forwardChat["type"] ?? "";
    
    if (!in_array($chatType, ["channel", "group", "supergroup"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⚠️ يرجى إعادة توجيه رسالة من قناة أو مجموعة."
        ]);
        return;
    }
    
    $channelId = $forwardChat["id"];
    $channelUsername = $forwardChat["username"] ?? ("القناة " . $channelId);
    $inviteLink = $userStates[$userId]["invite_link"] ?? null;
    
    // تنظيف الحالة
    unset($userStates[$userId]["state"]);
    unset($userStates[$userId]["invite_link"]);
    saveData(USERS_FILE, $userStates);
    
    // التحقق من أن البوت مشرف في القناة
    $botId = explode(":", BOT_TOKEN)[0];
    $adminCheck = apiRequest("getChatMember", [
        "chat_id" => $channelId,
        "user_id" => $botId
    ]);
    
    if (!$adminCheck || !$adminCheck["ok"] || !in_array($adminCheck["result"]["status"], ["administrator", "creator"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ البوت ليس مشرفاً في هذه القناة/المجموعة.\n\n⚠️ يرجى:\n1️⃣ إضافة البوت كمشرف في القناة/المجموعة\n2️⃣ ثم أعد توجيه رسالة من القناة/المجموعة مرة أخرى."
        ]);
        return;
    }
    
    // حفظ القناة الخاصة بمعلوماتها الكاملة (مع channelId الحقيقي)
    if (addMandatoryChannel($channelId, $channelUsername, "private", $inviteLink)) {
        $message = sprintf($texts["channel_added_mandatory"], ($channelUsername != "القناة " . $channelId ? $channelUsername : "قناة/مجموعة خاصة")) . "\n\n✅ تم حفظ المعرف الحقيقي. الآن يمكن التحقق من الاشتراك بشكل صحيح!";
        if (!empty($inviteLink)) {
            $message .= "\n\n🔗 رابط القناة الإجبارية:\n".$inviteLink;
        }
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $message,
            "reply_markup" => buildKeyboard(adminPanelKeyboard(), true)
        ]);
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["channel_already_mandatory"]
        ]);
    }
}

function handleChannelForward($message, $userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isset($message["forward_from_chat"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["forward_message"]
        ]);
        return;
    }
    
    $forwardChat = $message["forward_from_chat"];
    $chatType = $forwardChat["type"] ?? "";
    
    // دعم القنوات والمجموعات (channel, group, supergroup)
    if (!in_array($chatType, ["channel", "group", "supergroup"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ يرجى إعادة توجيه رسالة من قناة أو مجموعة."
        ]);
        return;
    }
    
    $channelId = $forwardChat["id"];
    $channelUsername = $forwardChat["username"] ?? ("القناة " . $channelId);
    
    $botId = explode(":", BOT_TOKEN)[0];
    $adminCheck = apiRequest("getChatMember", [
        "chat_id" => $channelId,
        "user_id" => $botId
    ]);
    
    // للقنوات يجب أن يكون مشرف، للمجموعات يجب أن يكون عضو على الأقل
    if ($chatType == "channel") {
        if (!$adminCheck || !$adminCheck["ok"] || !in_array($adminCheck["result"]["status"], ["administrator", "creator"])) {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $texts["channel_not_admin"]
            ]);
            return;
        }
    } else {
        // للمجموعات، يجب أن يكون البوت عضو على الأقل
        if (!$adminCheck || !$adminCheck["ok"]) {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "⚠️ البوت ليس عضو في هذه المجموعة. يرجى إضافة البوت إلى المجموعة أولاً."
            ]);
            return;
        }
    }
    
    if (addUserChannel($userId, $channelId, $channelUsername)) {
        unset($userStates[$userId]["state"]);
        saveData(USERS_FILE, $userStates);
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => sprintf($texts["channel_added"], $channelUsername),
            "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
        ]);
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["channel_already_exists"]
        ]);
    }
}

function handlePrivateChannelForwardForRoulette($message, $userId, $chatId, &$userStates) {
    global $texts;
    
    if (!isset($message["forward_from_chat"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["forward_message"]
        ]);
        return;
    }
    
    $forwardChat = $message["forward_from_chat"];
    $chatType = $forwardChat["type"] ?? "";
    
    // التحقق من أن الرسالة من قناة (channel فقط)
    if ($chatType != "channel") {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ يرجى إعادة توجيه رسالة من قناة خاصة فقط."
        ]);
        return;
    }
    
    $channelId = $forwardChat["id"];
    $channelUsername = $forwardChat["username"] ?? ("القناة " . $channelId);
    $channelTitle = $forwardChat["title"] ?? ("القناة " . $channelId);
    
    // التحقق من أن البوت عضو في القناة
    $botId = explode(":", BOT_TOKEN)[0];
    $adminCheck = apiRequest("getChatMember", [
        "chat_id" => $channelId,
        "user_id" => $botId
    ]);
    
    if (!$adminCheck || !$adminCheck["ok"]) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⚠️ البوت ليس عضو في هذه القناة الخاصة.\n\nيرجى إضافة البوت إلى القناة الخاصة أولاً."
        ]);
        return;
    }
    
    // للقنوات الخاصة، يجب أن يكون البوت مشرف
    if (!in_array($adminCheck["result"]["status"], ["administrator", "creator"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["channel_not_admin"]
        ]);
        return;
    }
    
    // التحقق من أن المستخدم مشرف أو مالك في القناة
    $memberCheck = apiRequest("getChatMember", [
        "chat_id" => $channelId,
        "user_id" => $userId
    ]);
    
    if (!$memberCheck || !$memberCheck["ok"]) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ حدث خطأ في التحقق من صلاحياتك في القناة."
        ]);
        return;
    }
    
    $memberStatus = $memberCheck["result"]["status"];
    if (!in_array($memberStatus, ["administrator", "creator"])) {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "❗ يجب أن تكون أدمن أو مالك في القناة الخاصة لإضافتها."
        ]);
        return;
    }
    
    // إضافة القناة الخاصة إلى قائمة المستخدم
    // للقنوات الخاصة، نستخدم channelId مباشرة (لا يوجد username)
    $channelDisplayName = !empty($channelUsername) && $channelUsername != "القناة " . $channelId 
        ? $channelUsername 
        : $channelTitle;
    
    if (addUserChannel($userId, $channelId, $channelDisplayName)) {
        unset($userStates[$userId]["state"]);
        saveData(USERS_FILE, $userStates);
        
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => sprintf($texts["channel_added"], $channelDisplayName),
            "reply_markup" => buildKeyboard(mainMenuKeyboard($userId), true)
        ]);
    } else {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => $texts["channel_already_exists"]
        ]);
    }
}

// نقطة الدخول الرئيسية
$update = json_decode(file_get_contents("php://input"), true);

if ($update) {
    if (isset($update["message"])) {
        processMessage($update);
    } elseif (isset($update["callback_query"])) {
        processCallbackQuery($update);
    } elseif (isset($update["my_chat_member"])) {
        processMyChatMember($update);
    }
}
?>